#include "misc.h"

void static_init()
{
    unsigned short *tex;
    int x,y;
    int r;
    int i;

	static_tex = pvr_mem_malloc(512*512*2);
	tex = malloc(512*512*2);
	
    memset(tex, 0, 512*512*2);

    for(y=0; y<512; y++) {
	for(x=0; x<496; x+=31) {
	    r = rand();
	    for(i=0; i<31; i++) {
		tex[x+i+512*y] = (r&1) * 0xffff;
		r = r>>1;
	    }
	}
	r = rand();
	for(x=496; x<512; x++) {
	    tex[x+512*y] = (r&1) * 0xffff;
	    r = r>>1;
	}	
    }
	
	pvr_txr_load_ex(tex, static_tex, 512, 512, PVR_TXRLOAD_16BPP); //Correct format is 16BITS!
	free(tex);
}

float static_uv[16][2] = {
    {0.0, 0.0},
    {0.5, 0.0},
    {0.0, 0.5},
    {0.5, 0.5},

    {0.5, 0.0},
    {1.0, 0.0},
    {0.5, 0.5},
    {1.0, 0.5},

    {0.0, 0.5},
    {0.5, 0.5},
    {0.0, 1.0},
    {0.5, 1.0},

    {0.5, 0.5},
    {1.0, 0.5},
    {0.5, 1.0},
    {1.0, 1.0}};

int uvset = 0;

float static_height = 239;
float old_static_height = 240;

void static_one_frame()
{
	pvr_poly_cxt_t ctx;
	pvr_poly_hdr_t poly;
	pvr_vertex_t vert;
  
    float new;
    
	pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_NONTWIDDLED, 512, 512, static_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly, &ctx);
    pvr_prim(&poly, sizeof(poly));
	
	vert.argb = PVR_PACK_COLOR(0.8f, 0.8f, 0.8f, 0.8f);
	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
	vert.flags = PVR_CMD_VERTEX;
    
    vert.x = 1;
    vert.y = 1 + static_height;
    vert.z = 0.01001f;
    vert.u = static_uv[0+uvset][0] + randnum(100)/1000.0;
    vert.v = static_uv[0+uvset][1] + randnum(100)/1000.0;
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = 640;
    vert.y = 1 + static_height;
    vert.z = 0.01001f;
    vert.u = static_uv[1+uvset][0] + randnum(100)/1000.0;
    vert.v = static_uv[1+uvset][1] + randnum(100)/1000.0;
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = 1;
    vert.y = 480 - static_height;
    vert.z = 0.01001f;
    vert.u = static_uv[2+uvset][0] + randnum(100)/1000.0;
    vert.v = static_uv[2+uvset][1] + randnum(100)/1000.0;
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = 640;
    vert.y = 480 - static_height;
    vert.z = 0.01001f;
    vert.u = static_uv[3+uvset][0] + randnum(100)/1000.0;
    vert.v = static_uv[3+uvset][1] + randnum(100)/1000.0;
	vert.flags = PVR_CMD_VERTEX_EOL;
	pvr_prim(&vert, sizeof(vert));

    uvset+=4;
    uvset = uvset%16;

    if (static_height > 0)
    {
	new = static_height - (old_static_height - static_height) * 1.5;
	old_static_height = static_height;
	static_height = new;
    }	
    if (static_height < 0)
	static_height = 0;
}
