#include "misc.h"

int shiverpos = 0;

void shiver(pvr_ptr_t tex, float a, float dodgyfix)
{
	pvr_poly_cxt_t ctx;
	pvr_poly_hdr_t poly;
	pvr_vertex_t vert;
  
    int i;

	pvr_poly_cxt_txr(&ctx, PVR_LIST_TR_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 512, 512, tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly, &ctx);
	pvr_prim(&poly, sizeof(poly));
	
    for(i=0; i<120; i++) {
    
	vert.argb = PVR_PACK_COLOR(a, 1.0f, 1.0f, 1.0f);
	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
	vert.flags = PVR_CMD_VERTEX;
	
	vert.x = 1+16*SIN(shiverpos) - dodgyfix;
	vert.y = 1+i*4;
	vert.z = 0.011f;
	vert.u = 0.0;
	vert.v = i/120.0f;
	pvr_prim(&vert, sizeof(vert));

	vert.x = 640+16*SIN(shiverpos) + dodgyfix;
	vert.y = 1+i*4;
	vert.z = 0.011f;
	vert.u = 1.0;
	vert.v = i/120.0f;
	pvr_prim(&vert, sizeof(vert));

	
	vert.x = 1+16*SIN(shiverpos) - dodgyfix;
	vert.y = 1+(i+1)*4;
	vert.z = 0.011f;
	vert.u = 0.0;
	vert.v = (i+1)/120.0f;
	pvr_prim(&vert, sizeof(vert));

	
	vert.x = 640+16*SIN(shiverpos) + dodgyfix;
	vert.y = 1+(i+1)*4;
	vert.z = 0.011f;
	vert.u = 1.0;
	vert.v = (i+1)/120.0f;
	vert.flags = PVR_CMD_VERTEX_EOL;
	pvr_prim(&vert, sizeof(vert));


	shiverpos += 16;
    }

}
