#include "misc.h"

float zoom = 1.0f;
float zoominc = 0.05f;
float rz_coords[4][3] = {
    { -0.48, -0.36, 1.0 },
    { 0.48, -0.36, 1.0 },
    { -0.48, 0.36, 1.0 },
    { 0.48, 0.36, 1.0 }
};
float rz_trans_coords[4][4];
int roto = 0;

void rotozoom_init(void)
{
	zoom512 = pvr_mem_malloc(512*512*2);
    jpeg_to_texture(NPM_FILE, zoom512, 512, 1);

	zoom256 = pvr_mem_malloc(256*256*2);
    jpeg_to_texture(NPM_FILE, zoom256, 256, 2);

	zoom128 = pvr_mem_malloc(128*128*2);
    jpeg_to_texture(NPM_FILE, zoom128, 128, 4);

	zoom64 = pvr_mem_malloc(64*64*2);
    jpeg_to_texture(NPM_FILE, zoom64, 64, 8);
}

void rotozoom_one_frame(pvr_ptr_t tex, float a, int w)
{
	pvr_poly_cxt_t ctx;
	pvr_poly_hdr_t poly;
	pvr_vertex_t vert;

    pvr_poly_cxt_txr(&ctx, PVR_LIST_TR_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, w, w, tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly, &ctx);
	pvr_prim(&poly, sizeof(poly));
	
	vert.argb = PVR_PACK_COLOR(a, 1.0f, 1.0f, 1.0f);
	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
    vert.flags = PVR_CMD_VERTEX;
    
    vert.x = rz_trans_coords[0][0];
    vert.y = rz_trans_coords[0][1];
    vert.z = 0.011f;
    vert.u = -0.25 * zoom;
    vert.v = -0.25 * zoom;
   	pvr_prim(&vert, sizeof(vert));

    vert.x = rz_trans_coords[1][0];
    vert.y = rz_trans_coords[1][1];
    vert.z = 0.011f;
    vert.u = 1.25 * zoom;
    vert.v = -0.25 * zoom;
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = rz_trans_coords[2][0];
    vert.y = rz_trans_coords[2][1];
    vert.z = 0.011f;
    vert.u = -0.25 * zoom;
    vert.v = 1.25 * zoom;
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = rz_trans_coords[3][0];
    vert.y = rz_trans_coords[3][1];
    vert.z = 0.011f;
    vert.u = 1.25 * zoom;
    vert.v = 1.25 * zoom;
	vert.flags = PVR_CMD_VERTEX_EOL;
	pvr_prim(&vert, sizeof(vert));
}

void do_rotozoom(float a, int go)
{
    clear_matrix();
    apply_matrix(&screenview_matrix);
    apply_matrix(&projection_matrix);
    translate(0.0f, 0.0f, -0.41f);
    rotate_z(roto);
    
    transform_coords(rz_coords, rz_trans_coords, 4);
    
    if (zoom < 1.5f)
	rotozoom_one_frame(zoom512, a, 512);
    else if (zoom < 3.0f)
	rotozoom_one_frame(zoom256, a, 256);
    else if (zoom < 6.0f)
	rotozoom_one_frame(zoom128, a, 128);
    else
	rotozoom_one_frame(zoom64, a, 64);
    
    if (go) {
	if ((zoom > 10.0f)||(zoom < 1.0f))
	    zoominc *= -1.0f;
	zoom += zoominc;
	roto+=6;
    }

}

void npm_one_frame(void)
{
  pvr_poly_cxt_t ctx;
  pvr_poly_hdr_t poly;
  pvr_vertex_t vert;
  
  pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 512, 512, zoom512, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &ctx);
  pvr_prim(&poly, sizeof(poly));
  
  vert.argb = PVR_PACK_COLOR(0.8f, 0.8f, 0.8f, 0.8f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;
   
  vert.x = 1;
  vert.y = 1;
  vert.z = 0.0101f;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 640;
  vert.y = 1;
  vert.z = 0.0101f;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));
  
  vert.x = 1;
  vert.y = 480;
  vert.z = 0.0101f;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));
  
  vert.x = 640;
  vert.y = 480;
  vert.z = 0.0101f;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));

}
