#include "misc.h"

void putpixel(short x, short y, short color, short *buffer)
{
    if ((y>0)&&(y<128)&&(x>0)&&(x<128)) 
	buffer[y*128+x] = color;
}

void drawcircle(short x, short y, short r, short color, short *buffer)
{
    short cx = 0;
    short cy = r;
    short df = 1 - r;
    short d_e = 3;
    short d_se = -2 * r + 5;
    
    do {
	putpixel(x+cx, y+cy, color, buffer);
	putpixel(x-cx, y+cy, color, buffer);
	putpixel(x+cx, y-cy, color, buffer);
	putpixel(x-cx, y-cy, color, buffer);
	putpixel(x+cy, y+cx, color, buffer);
	putpixel(x+cy, y-cx, color, buffer);
	putpixel(x-cy, y+cx, color, buffer);
	putpixel(x-cy, y-cx, color, buffer);
	if (df < 0)  {
	    df += d_e;
	    d_e += 2;
	    d_se += 2;
	} else {
	    df += d_se;
	    d_e += 2;
	    d_se += 4;
	    cy--;
	}
	cx++;
    } while(cx <= cy);
}

short *inter = 0;

void inter_init()
{
    int i;
    unsigned short * tex;

    if (!inter)
	inter = malloc(128*128*2);

    memset(inter, 0x0, 128*128*2);

	inter_tex = pvr_mem_malloc(64*64*2);
	tex = inter_tex;
	
    memset(tex, 0, 64*64*2);

    for(i=1; i<181; i+=6) {
	drawcircle(63, 63, i, 0xffff, inter);
	drawcircle(63, 63, i+1, 0xffff, inter);
    }
}

void inter_shutdown() {
	free(inter);
	inter = NULL;
}

int ox1 = 0;
int oy1 = 0;
int dx1 = 1;
int dy1 = 1;

int ox2 = 64;
int oy2 = 64;
int dx2 = -1;
int dy2 = -1;
    
void inter_one_frame()
{
    int x,y;
	unsigned short *tex = inter_tex;
	
    x = 0;

    for(y=0; y<64; y++)
	for(x=0; x<64; x++)
	    tex[x+y*64] = inter[x+ox1+(y+oy1)*128] ^ inter[x+ox2+(y+oy2)*128+6];

	ox1+=dx1*randnum(2);
	oy1+=dy1*randnum(2);
	ox2+=dx2*randnum(2);
	oy2+=dy2*randnum(2);
	
	if (ox1<0) {
	    dx1 = 1;
	    ox1 = 0;
	}
	if (ox1>64) {
	    dx1 = -1;
	    ox1 = 64;
	}
	if (oy1<0) {
	    dy1 = 1;
	    oy1 = 0;
	}
	if (oy1>64) {
	    dy1 = -1;
	    oy1 = 64;
	}
	if (ox2<0) {
	    dx2 = 1;
	    ox2 = 0;
	}
	if (ox2>64) {
	    dx2 = -1;
	    ox2 = 64;
	}
	if (oy2<0) {
	    dy2 = 1;
	    oy2 = 0;
	}
	if (oy2>64) {
	    dy2 = -1;
	    oy2 = 64;
	}
}
