#include "misc.h"

#define ROOTRAND 20
#define DECAY 10
#define MINY 1
#define SMOOTH 1
#define MINFIRE 50
#define XSTART 0
#define XEND 63
#define WIDTH (XEND - XSTART + 1)
#define FIREINCREASE 3
#define MOREFIRE 0

unsigned char *firebuf = NULL;
unsigned char *flamearray;
unsigned short fire_col[256];

void fire_init() {
    int i;
	unsigned short * tex;

	fire_tex = pvr_mem_malloc(64*64*2);
	tex = fire_tex;
	
	memset(tex, 0, 64*64*2);
	memset(tex, 255, 64*2);
	memset(&tex[63*64], 255, 64*2);
	for(i=1; i<63; i++) {
	    tex[i*64] = 0xffff;
	    tex[i*64+63] = 0xffff;
	}

	firebuf = malloc(64*64);
	memset(firebuf, 0, 64*64);
	
	flamearray = malloc(WIDTH);
	memset(flamearray, 0, WIDTH);

        for (i=0; i<WIDTH; i++)
                flamearray[i] = randnum(16) + 32;
        
        for (i=0; i<128; i++) {
	    int r = i;
	    int g = 0;
	    int b = 0;
	    short col = ((r >> 3) << 11)
		| ((g >> 2) << 5)
		| (b >> 3);
	    fire_col[i] = col;
        }
        for (i=128; i<256; i++) { /* this really should just use i */
	    int r = i;            /* but my gcc snapshot is a bit buggy */
	    int g = (i-128)*2;
	    int b = 0;
	    short col = ((r >> 3) << 11)
		| ((g >> 2) << 5)
		| (b >> 3);
	    fire_col[i] = col;
        }
}

void fire_shutdown() {
	free(firebuf);
	free(flamearray);
}

void fire_one_frame() {
        int i, x, y;
		unsigned short *vrout =  fire_tex;

        /* Put the values from flamearray on the bottom of the screen */
        memcpy(firebuf+64*63+XSTART, flamearray, WIDTH);

        /* This loop makes the actual flames */
        for (x=XSTART; x<=XEND; x++) {
                for (y=MINY; y<64; y++) {
                        int v = firebuf[y*64+x];
                        if (v==0 || v<DECAY || x<=XSTART || x>=XEND) {
                                firebuf[(y-1)*64+x] = 0;
                        } else {
                                v = v - randnum(DECAY);
                                if (v < 0) v = 0;
                                if (v > 255) v = 255;
                                firebuf[(y-1)*64 + (x + (randnum(4)-2))] = v;
                        }
                }
        }
        
        /* This loop controls the "root" of the flames, i.e., the values
           in flamearray */
        for (i=0; i<WIDTH; i++) {
                x = flamearray[i];
                if (x<MINFIRE) {
                        if (x > 10)
                                x += randnum(FIREINCREASE);
                } else {
                        x += randnum(ROOTRAND) + MOREFIRE;
                }
                if (x > 255) x = 255;
                if (x < 0) x = 0;
                flamearray[i] = x;
        }
	
        for (y=1; y<63; y++) {
                for (x=1; x<63; x++) {
                        vrout[y*64+x] = fire_col[firebuf[y*64+x]];
                }
        }
}
