#include "misc.h"

/* coordinates for the cube */

float coords[8][3] = {
    { -1.0, -1.0, -1.0 },
    {  1.0, -1.0, -1.0 },
    { -1.0,  1.0, -1.0 },
    {  1.0,  1.0, -1.0 },
    { -1.0, -1.0,  1.0 },
    {  1.0, -1.0,  1.0 },
    { -1.0,  1.0,  1.0 },
    {  1.0,  1.0,  1.0 },
};

/* transformed coordinates */

float trans_coords[8][4];

void draw_face(float *p1, float *p2, float *p3, float *p4)
{
   	pvr_vertex_t vert;

	vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
    vert.flags = PVR_CMD_VERTEX;
    
    vert.x = p1[0];
    vert.y = p1[1];
    vert.z = p1[3];
    vert.u = 0.0;
    vert.v = 0.0;
	pvr_prim(&vert, sizeof(vert));

    
    vert.x = p2[0];
    vert.y = p2[1];
    vert.z = p2[3];
    vert.u = 1.0;
    vert.v = 0.0;
   	pvr_prim(&vert, sizeof(vert));

    vert.x = p3[0];
    vert.y = p3[1];
    vert.z = p3[3];
    vert.u = 0.0;
    vert.v = 1.0;
	pvr_prim(&vert, sizeof(vert));

    vert.x = p4[0];
    vert.y = p4[1];
    vert.z = p4[3];
    vert.u = 1.0;
    vert.v = 1.0;
	vert.flags = PVR_CMD_VERTEX_EOL;
	pvr_prim(&vert, sizeof(vert));
}

//KOS 2.X: ALL OUR TEXTURES ARE NONTWIDDLED!!!
void cube_one_frame(float x, float y, float z, int rot)
{
	pvr_poly_cxt_t ctx;
	pvr_poly_hdr_t poly[5];
    
    /* draw cube */
 
    clear_matrix();
    apply_matrix(&screenview_matrix);
    apply_matrix(&projection_matrix);
    translate(x, y, z);

    rotate_x(rot);
    rotate_y(rot*2);
    rotate_z(rot*4);
    
    transform_coords(coords, trans_coords, 8);
    
    pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_NONTWIDDLED, 64, 64, inter_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly[0], &ctx);
	pvr_prim(&poly[0], sizeof(pvr_vertex_t));

    draw_face(trans_coords[4], trans_coords[5], trans_coords[0],
              trans_coords[1]);

	pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_NONTWIDDLED, 64, 64, fire_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly[1], &ctx);
    pvr_prim(&poly[1], sizeof(pvr_vertex_t));
	
    draw_face(trans_coords[4], trans_coords[0], trans_coords[6],
              trans_coords[2]);

	pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_NONTWIDDLED, 64, 64, stars_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly[2], &ctx);
	pvr_prim(&poly[2], sizeof(pvr_vertex_t));

    draw_face(trans_coords[1], trans_coords[5], trans_coords[3],
              trans_coords[7]);

	pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_NONTWIDDLED, 64, 64, special_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly[3], &ctx);
	pvr_prim(&poly[3], sizeof(pvr_vertex_t));
	
    draw_face(trans_coords[0], trans_coords[1], trans_coords[2],
              trans_coords[3]);
    draw_face(trans_coords[5], trans_coords[4], trans_coords[7],
              trans_coords[6]);

	pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_NONTWIDDLED, 64, 64, plasma_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly[4], &ctx);
	pvr_prim(&poly[4], sizeof(pvr_vertex_t));

    draw_face(trans_coords[2], trans_coords[3], trans_coords[6],
              trans_coords[7]);
}

void npm_cube_one_frame(float x, float y, float z, int rot, float s)
{
    pvr_poly_cxt_t ctx;
	pvr_poly_hdr_t poly;
   
    clear_matrix();
    apply_matrix(&screenview_matrix);
    apply_matrix(&projection_matrix);
    translate(x, y, z);

    rotate_x(rot);
    rotate_y(rot*2);
    rotate_z(rot*4);

    scale(s, s, s);
    
    transform_coords(coords, trans_coords, 8);
    
    pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 64, 64, zoom64, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly, &ctx);
	pvr_prim(&poly, sizeof(poly));
	
    draw_face(trans_coords[4], trans_coords[5], trans_coords[0],
              trans_coords[1]);
    
    draw_face(trans_coords[4], trans_coords[0], trans_coords[6],
              trans_coords[2]);

    draw_face(trans_coords[1], trans_coords[5], trans_coords[3],
              trans_coords[7]);

    draw_face(trans_coords[0], trans_coords[1], trans_coords[2],
              trans_coords[3]);
    draw_face(trans_coords[5], trans_coords[4], trans_coords[7],
              trans_coords[6]);

    draw_face(trans_coords[2], trans_coords[3], trans_coords[6],
              trans_coords[7]);
}
