//Use KOS 2.X AICA, MAPLE, PVR...

#include "misc.h"
#include "s3mplay.h"
#include "vmu_icon.h"
#include "pal.h"

//DC Romdisk Init
extern uint8 romdisk[];
KOS_INIT_FLAGS(INIT_DEFAULT);
KOS_INIT_ROMDISK(romdisk);

int st_x = 0;
int st_i = 0;
int c_rot = 0;

volatile unsigned long *snd_dbg = (unsigned long*)0xa080ffc0;

void play_s3m(char *fn) 
{
    int idx, r;
    FILE *fd;
    unsigned char buffer[2048];
    
	spu_disable();
    
    fd = fopen(fn, "rb");
    if (fd == NULL) {
		return;
    }
    
    idx = 0x10000;
    /* Load 2048 bytes at a time */
    while ( (r = fread(buffer, 1, 2048, fd)) > 0) {
		spu_memload(idx, buffer, r);
		idx += r;
    }
    fclose(fd);
    
    spu_memload(0, s3mplay, sizeof(s3mplay));
    spu_enable();
    
    while (*snd_dbg != 3)
	thd_pass();
    
    while (*snd_dbg == 3)
	thd_pass();
}

void do_cube()
{
    static float z = 100.0f;
	
    special_one_frame();

    stars_one_frame();

    plasma_one_frame();

    fire_one_frame();

    inter_one_frame();

	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
    
    cube_one_frame(SIN(c_rot*2),0,z+COS(c_rot*2),c_rot);
    c_rot+=3;
     
	pvr_list_finish();
 	pvr_list_begin(PVR_LIST_TR_POLY);

    shiver(y2k_tex, 1.0f, 16.0f);
	
    sinus_text(st_x, 32, 1, 1, 1, 1, 1, &scrolltext[st_i], 1, 1);
    st_x -= 4;
    if (st_x == -32) {
      st_i++;
      st_x = 0;
    }
    if (!(scrolltext[st_i]))
      st_i = 0;

	pvr_list_finish();
	pvr_scene_finish();

    if (z > 5.0f)
	z -= 1.0f;

    if (st_i == 400) {
	while (z < 100.0f) {

	    z += 1.0f;

	    special_one_frame();
	    
	    stars_one_frame();
	    
	    plasma_one_frame();
	    
	    fire_one_frame();
	    
	    inter_one_frame();
	    
		pvr_wait_ready();
		pvr_scene_begin();
		pvr_list_begin(PVR_LIST_OP_POLY);
	    
	    cube_one_frame(SIN(c_rot*2),0,z+COS(c_rot*2),c_rot);
	    c_rot+=6;
	    
		pvr_list_finish();
		pvr_list_begin(PVR_LIST_TR_POLY);
	    
	    shiver(y2k_tex, 1.0f, 16.0f);
   
		pvr_list_finish();
		pvr_scene_finish();
	}
	
    }
}

int brot = 0;

void do_beetle()
{
    static float z = 100.0f;
	
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
	
    draw_beetle(0.0f, 0.0f, z, brot*4,brot*3,brot*2, 0.03f); 
    
    beetle_orbit(0.0f, 0.0f, z);
    
    brot += 3;

	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);
		
    shiver(y2k_tex, 1.0f, 16.0f);

    sinus_text(st_x, 32, 1, 1, 1, 1, 1, &scrolltext[st_i], 1, 1);
    st_x -= 4;
    if (st_x == -32) {
      st_i++;
      st_x = 0;
    }
    if (!(scrolltext[st_i]))
      st_i = 0;

	pvr_list_finish();
	pvr_scene_finish();
		
    if (z > 4.0f)
	z -= 1.0f;
 
    if (st_i >= 800) {
	while (z < 100.0f) {

	    z += 1.0f;

		pvr_wait_ready();
		pvr_scene_begin();
		pvr_list_begin(PVR_LIST_OP_POLY);
	    
	    draw_beetle(0.0f, 0.0f, z, brot*4,brot*3,brot*2, 0.03f); 
	    
	    beetle_orbit(0.0f, 0.0f, z);
	    
	    brot += 3;
	    
		pvr_list_finish();
		pvr_list_begin(PVR_LIST_TR_POLY);
	    
	    shiver(y2k_tex, 1.0f, 16.0f);

		pvr_list_finish();
		pvr_scene_finish();
	    
	}
	
    }
}

int done = 0;

void do_my_bidding()
{
    
    if (st_i < 400)
	do_cube();
    else
	do_beetle();
    if (st_i >= 800)
	done = 1;

	//Use new Maple System: START means done
	maple_device_t *mcont;
	cont_state_t *cond;
	
	mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
	if (!mcont) return;
	
	cond = (cont_state_t *)maple_dev_status(mcont);
	if (cond) 
	{
		if(cond->buttons & CONT_START) done = 1;
	}
  
}

void do_outro()
{
    float a = 0.0f;

  /* fade out y2kode */
  for(a = 1.0f; a >= 0.0f ; a -= 0.01f) {
      particle_calc_one_frame();
	  
	  pvr_wait_ready();
	  pvr_scene_begin();
	  pvr_list_begin(PVR_LIST_OP_POLY);
      npm_one_frame();
	  pvr_list_finish();
	  pvr_list_begin(PVR_LIST_TR_POLY);  
      shiver(y2k_tex, a, 16.0f);
      particle_render_one_frame(1.0f);
	  pvr_list_finish();
	  pvr_scene_finish();
  }
}

int credits_y = 480;
int credits_s = 0;
int credits_done = 0;
int exittro = 0;

void credits_one_frame()
{
    int i;
    static float a = 0.0f;

    if (a < 1.0f)
	particle_calc_one_frame();
    
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
	
    if (!exittro) {
      npm_one_frame();
	  pvr_list_finish();
	  pvr_list_begin(PVR_LIST_TR_POLY); 
	  
    } else {
	  pvr_list_finish();
	  pvr_list_begin(PVR_LIST_TR_POLY); 
      shiver(zoom512, 0.8f, 0.0f);
    }

    if (a < 1.0f)
	particle_render_one_frame(1.0f - a);
    
    i = credits_s;
    while(!credits_done) {
	if (credits_y >= 480)
	    break;
	if (!strcmp(credits[i],"END"))
	    break;
	draw_string(320.0f - strlen(credits[i])*16, credits_y + (i-credits_s)*48, 5.0f, 1.0f, 1.0f, 1.0f, 1.0f, credits[i], 1.0f, 1.0f);
	i++;
    }

    if (strcmp(credits[credits_s+1],"END")) {

	credits_y -= 1.0f;    
	
	if (credits_y < -47) {
	    credits_s++;
	    credits_y = 0;
	}
    } else
	credits_done = 1;

    if (credits_done) {
	draw_string(320.0f - strlen("PRESS <START> TO EXIT")*8, 16.0f, 5.0f, a, 1.0f, 1.0f, 1.0f, "PRESS <START> TO EXIT", 0.5f, 0.5f);
	draw_string(320.0f - strlen("NAPALM / 2001")*16, 416.0f, 5.0f, a, 1.0f, 1.0f, 1.0f, "NAPALM / 2001", 1.0f, 1.0f);
	if (a < 1.0f)
	    a += 0.01f;
	else
	    exittro = 1;
    }

	pvr_list_finish();
	pvr_scene_finish();
}

void do_credits()
{
	//Use new Maple System: START means done
	maple_device_t *mcont;
	cont_state_t *cond;
	
    while(1) {
		mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
		if (!mcont) return;
	
		cond = (cont_state_t *)maple_dev_status(mcont);
		if (cond) 
		{
			if(cond->buttons & CONT_START) break;
		}

		credits_one_frame();
    }
}

//KOS 2.X: Just call a coolest function! :)
void vmu_icon_init() {
	vmu_set_icon(vmu_icon);
}

int main()
{
	fs_chdir("/rd/");

	//Init basic KOS stuff :) No need to init TA, FS, Maple, Thread, SPU...
	int dc_region, ct;
  
	dc_region = flashrom_get_region();
	ct = vid_check_cable();
 
	/* Prompt the user for whether to run in PAL50 or PAL60 if the flashrom says
	the Dreamcast is European and a VGA Box is not hooked up. */
	if(dc_region == FLASHROM_REGION_EUROPE && ct != CT_VGA) {
		if(pal_menu()) {
			vid_set_mode(DM_640x480_NTSC_IL, PM_RGB565);
		}
		else {
			vid_set_mode(DM_640x480_PAL_IL, PM_RGB565);
		}
	}
	else vid_set_mode(DM_640x480_NTSC_IL, PM_RGB565);
  
	pvr_init_defaults();
	
	//Draw VMU
    vmu_icon_init();

    title_init();
    stars_init();
    plasma_init();
    fire_init();
    inter_init();
    static_init();
    special_init();
    font_init();
    particle_init();
    beetle_init();
    rotozoom_init();

	//Play S3M Music
	play_s3m(S3M_FILE);
        
    do_title();
    
    while(!done) 
 	do_my_bidding();
    
    do_outro();
  
    do_credits();

	//Ending
	spu_disable();
	
    inter_shutdown();
    plasma_shutdown();
    stars_shutdown();
    fire_shutdown();
	
	pvr_shutdown();
  
    return 0;
}
