#include "misc.h"

#define NS 512
int     *star_x = NULL, *star_y, *star_z;
int     *star_x1, *star_y1;
unsigned short *color_trans;

#define zk 64
#define MAXX ((64*(zk+64))/zk)
#define MAXY ((64*(zk+64))/zk)

void stars_init()
{
    int i;
    unsigned short * tex;
    
	stars_tex = pvr_mem_malloc(64*64*2);
	tex = stars_tex;
	
    memset(tex, 0, 64*64*2);
    memset(tex, 255, 64*2);
    memset(&tex[63*64], 255, 64*2);
    for(i=1; i<63; i++) {
      tex[i*64] = 0xffff;
      tex[i*64+63] = 0xffff;
    }
    
    if (star_x == NULL) {
	star_x = malloc(NS*sizeof(int));
	star_y = malloc(NS*sizeof(int));
	star_z = malloc(NS*sizeof(int));
	star_x1 = malloc(NS*sizeof(int));
	star_y1 = malloc(NS*sizeof(int));
	color_trans = malloc(256*sizeof(unsigned short));
    } else {
	memset(star_x1, 0, NS*sizeof(int));
	memset(star_y1, 0, NS*sizeof(int));
    }
    
    for (i=0; i<NS; i++) {
	star_x[i]=randnum(MAXX)-(MAXX/2);
	star_y[i]=randnum(MAXY)-(MAXY/2);
	star_z[i]=randnum(64);
    }
    
    for (i=0; i<256; i++)
	color_trans[i] = ((i >> 3) << 11)
	    | ((i >> 2) << 5)
	    | (i >> 3);
}

void stars_shutdown() {
	free(star_x); star_x = NULL;
	free(star_y);
	free(star_z);
	free(star_x1);
	free(star_y1);
	free(color_trans);
}

void stars_one_frame() 
{
    int i, x1, y1, xn, yn, zn, c;
    unsigned short *tex;

	tex = stars_tex;

    /* Calculate each star's position and plot it on screen */
    for (i=0; i<NS; i++) {
	tex[star_y1[i]*64+star_x1[i]] = 0;
	
	/* Calculate star perspective */
	xn = star_x[i]; yn = star_y[i]; zn = star_z[i];
	x1 = xn*zk / (zn + zk);
	y1 = yn*zk / (zn + zk);
	
	if (x1>-31 && y1>-31 && x1<31 && y1<31) {
	    c = (zn * 256/64) & 0xff;
	    tex[(y1+32)*64+x1+32] = color_trans[255 - c];
	    star_y1[i] = y1+32; star_x1[i] = x1+32;       /* save coords */
	} else {
	    star_y1[i] = 0;
	    star_x1[i] = 0;
	    star_z[i] = 64;
	}
	
	/* Move star's Z coord to show motion inward */
	star_z[i]-=2;
    }
}
