/* Tryptonite

   pvrutils.h
   (c)2000 Dan Potter

*/

#ifndef __PVRUTILS_H
#define __PVRUTILS_H

#include <kos.h>

typedef unsigned short uint16;
typedef unsigned long uint32;
typedef signed short int16;
typedef signed long int32;

/* Twiddle function -- copies from a source rectangle in SH-4 ram to a
   destination texture in PVR ram. */
void txr_twiddle_copy(const uint16 *src, uint32 srcw, uint32 srch,
		pvr_ptr_t dest, uint32 destw, uint32 desth, uint16 bkg);

/* Twiddle function -- copies from a source rectangle in SH-4 ram to a
   destination texture in PVR ram. The image will be scaled to the texture
   size. */
void txr_twiddle_scale(const uint16 *src, uint32 srcw, uint32 srch,
		uint32 dest, uint32 destw, uint32 desth);


#endif	/* __PVRUTILS_H */
