/* Tryptonite

   pvrutils.c
   (c)2000 Dan Potter

   PVR Utility Functions
*/

#include "pvrutils.h"

/* Linear/iterative twiddling algorithm from Marcus' tatest */
#define TWIDTAB(x) ( (x&1)|((x&2)<<1)|((x&4)<<2)|((x&8)<<3)|((x&16)<<4)| \
	((x&32)<<5)|((x&64)<<6)|((x&128)<<7)|((x&256)<<8)|((x&512)<<9) )
#define TWIDOUT(x, y) ( TWIDTAB((y)) | (TWIDTAB((x)) << 1) )

/* Twiddle function -- copies from a source rectangle in SH-4 ram to a
   destination texture in PVR ram. Areas outside the source texture will
   be filled with bgcol. */
void txr_twiddle_copy(const uint16 *src, uint32 srcw, uint32 srch,
		pvr_ptr_t dest, uint32 destw, uint32 desth, uint16 bgcol) {
	int	x, y;
	uint16	*vtex;
	uint16	val;
	
	vtex = (uint16*)dest;
	
	for (y=0; y<desth; y++) {
		for (x=0; x<destw; x++) {
			if (x >= srcw || y >= srch)
				val = bgcol;
			else
				val = src[y*srcw+x];
			vtex[TWIDOUT(x,y)] = val;
		}
	}
}

/* Twiddle function -- copies from a source rectangle in SH-4 ram to a
   destination texture in PVR ram. The image will be scaled to the texture
   size. */
void txr_twiddle_scale(const uint16 *src, uint32 srcw, uint32 srch,
		uint32 dest, uint32 destw, uint32 desth) {
	int	x, y, srcx, srcy;
	uint16	*vtex;
	uint16	val;
	float	scalex, scaley;
	
	vtex = (uint16*)dest;
	
	scalex = srcw * 1.0f / destw;
	scaley = srch * 1.0f / desth;
	
	for (y=0; y<desth; y++) {
		for (x=0; x<destw; x++) {
			srcx = (int)(x*scalex);
			srcy = (int)(y*scaley);
			val = src[srcy*srcw+srcx];
			vtex[TWIDOUT(x,y)] = val;
		}
	}
}

