#include "misc.h"

unsigned char *cos_table = 0;
unsigned char hptr1, hptr2, vptr1, vptr2;
unsigned char ptr[4];
unsigned short *plasma_col = 0;

void plasma_init()
{
    int a;
    unsigned short * tex;

	plasma_tex = pvr_mem_malloc(64*64*2);
	tex = plasma_tex;
	
    memset(tex, 0, 64*64*2);

    if (!cos_table)
	cos_table = malloc(256);

    for(a=0; a<256; a++)
        cos_table[a]=(unsigned char)((COS((a*4))*32)+32);

    if (!plasma_col)
	plasma_col = malloc(64*2);
    
    for (a=0; a<32; a++) {
	int r = a*6;
	int g = a*8;
	int b = 0;
	short col = ((r >> 3) << 11)
	    | ((g >> 2) << 5)
	    | (b >> 3);
	plasma_col[a] = col;
    }
    for (a=0; a<32; a++) {
	plasma_col[32+a] = plasma_col[31 - a];
    }

    hptr1 = 0;
    hptr2 = 0;
    vptr1 = 0;
    vptr2 = 0;
    
    ptr[0]=hptr1;
    ptr[1]=hptr2;
    ptr[2]=vptr1;
    ptr[3]=vptr2;
}

void plasma_shutdown() {
	free(plasma_col); plasma_col = NULL;
	free(cos_table); cos_table = NULL;
}

void plasma_one_frame()
{
    unsigned int where = 0;
    int x = 0, y = 0;
	unsigned short *tex = plasma_tex;

    vptr1=ptr[2];
    vptr2=ptr[3];
    for(y=0; y<64; y++) {
	vptr1++;
	vptr2+=2;
	hptr1=ptr[0];
	hptr2=ptr[1];
	for (x=0; x<64; x++) {
	    hptr1+=3;
	    hptr2+=4;
	    tex[where++]=plasma_col[(cos_table[hptr1]+cos_table[hptr2]+
				   cos_table[vptr1]+cos_table[vptr2])%64];
	}
    }
    ptr[0]-=4;
    ptr[1]+=3;
    ptr[2]-=2;
    ptr[3]+=1;
}
