#include "misc.h"

#define NUM_PARTICLES 400

particle particles[NUM_PARTICLES];
float line_cx = 0.0;
float line_cy = 0.0;
float line_cz = 0.0;
int line_a = 0;
unsigned int last_jiffies = 1;

void particle_init(void)
{
    int i;

    for(i = 0; i < NUM_PARTICLES; i++) {
	particles[i].direction[0] = 0.0;
	particles[i].direction[1] = 0.0;
	particles[i].direction[2] = 0.0;
	particles[i].coord[0][0] = 0.0;
	particles[i].coord[0][1] = 0.0;
	particles[i].coord[0][2] = 0.0;
	particles[i].coord[1][0] = 0.0;
	particles[i].coord[2][1] = 0.0;
	particles[i].coord[3][2] = 0.0;
	particles[i].energy = 0.0;
    }
    
	particle_tex = pvr_mem_malloc(32*32*2);
    bin_to_texture(STAR_FILE, particle_tex, 32, 32);
}	

void new_particle(int i, float x, float y, float z)
{
    particles[i].coord[0][0] = x - 0.1f;
    particles[i].coord[0][1] = y - 0.1f;
    particles[i].coord[0][2] = z;
    particles[i].coord[1][0] = x + 0.1f;
    particles[i].coord[1][1] = y + 0.1f;
    particles[i].coord[1][2] = z;
    particles[i].direction[0] = (randnum(32768)/16384.0 - 1.0)/100.0;
    particles[i].direction[1] = (randnum(32768)/16384.0 - 1.0)/100.0;
    particles[i].direction[2] = (randnum(32768)/16384.0 - 1.0)/100.0;
    particles[i].energy = 0.1 + randnum(32768)/36408.8889;
}

void draw_particle(float (*trans_coords)[4], float energy)
{
	pvr_vertex_t vert;

	vert.argb = PVR_PACK_COLOR(energy, 1.0f, 1.0f, 1.0f);

	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);

	vert.flags = PVR_CMD_VERTEX;

    vert.x = trans_coords[0][0];
    vert.y = trans_coords[0][1];
    vert.z = trans_coords[0][3];
    vert.u = 0.0;
    vert.v = 0.0;

	pvr_prim(&vert, sizeof(vert));

    vert.x = trans_coords[1][0];
    vert.u = 1.0;
	pvr_prim(&vert, sizeof(vert));

    vert.x = trans_coords[0][0];
    vert.y = trans_coords[1][1];
    vert.u = 0;
    vert.v = 1.0;
	pvr_prim(&vert, sizeof(vert));
    
	vert.flags = PVR_CMD_VERTEX_EOL;
    vert.x = trans_coords[1][0];
    vert.y = trans_coords[1][1];
    vert.u = 1.0;
    vert.v = 1.0;
	pvr_prim(&vert, sizeof(vert));
}

int rot = 0;

void particle_render_one_frame(float a)
{
	pvr_poly_cxt_t ctx;
	pvr_poly_hdr_t poly;
	
    float trans_coords[2][4];
    int i;

    clear_matrix();
    apply_matrix(&screenview_matrix);
    apply_matrix(&projection_matrix);
    translate(0.0, 0.0, 5.0);
	
	pvr_poly_cxt_txr(&ctx, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB4444|PVR_TXRFMT_TWIDDLED, 32, 32, particle_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly, &ctx);
	pvr_prim(&poly, sizeof(poly));
	
    for(i = 0; i < NUM_PARTICLES; i++) {

	transform_coords(particles[i].coord, trans_coords, 2);
	
	draw_particle(trans_coords, particles[i].energy*a);
    }
}

void particle_calc_one_frame(void)
{
    float ax, ay, bx, by;
    int i;

    line_cx = SIN(line_a);
    line_cz = COS(line_a);

    ax = line_cx - 1.0 * SIN(line_a);
    ay = line_cy - 1.0 * COS(line_a);
    bx = line_cx + 1.0 * SIN(line_a);
    by = line_cy + 1.0 * COS(line_a);

    for(i = 0; i < NUM_PARTICLES; i++) {
	if (particles[i].energy < 0.125) {
	    float t = randnum(32768)/32768.0;
	    new_particle(i, (1-t)*ax + t*bx, (1-t)*ay + t*by, line_cz);
	} else {
	    particles[i].energy -=  randnum(32768)/3276800.0;
	    particles[i].coord[0][0] +=  particles[i].direction[0];
	    particles[i].coord[0][1] +=  particles[i].direction[1];
	    particles[i].coord[0][2] +=  particles[i].direction[2];
	    particles[i].coord[1][0] +=  particles[i].direction[0];
	    particles[i].coord[1][1] +=  particles[i].direction[1];
	    particles[i].coord[1][2] +=  particles[i].direction[2];
	}
    }

    line_a += 6;
}
