#ifndef __MISC_H__
#define __MISC_H__

#define BACK_FILE  "background.jpg" 
#define TITLE_FILE "title.jpg"
#define FONT_FILE  "font.bin"
#define STAR_FILE  "star.bin"
#define BR1_FILE   "br1.jpg"
#define BR2_FILE   "br2.jpg"
#define BR3_FILE   "br3.jpg"
#define BR4_FILE   "br4.jpg"
#define S3M_FILE   "darkness.s3m"
#define NPM_FILE   "napalm.jpg"

#include <kos.h>

#include <stdio.h>
#include <malloc.h>

#include "matrix.h"
#include "sincos.h"
#include "memcpyskip.h"
#include "font.h"
#include "static.h"
#include "inter.h"
#include "fire.h"
#include "plasma.h"
#include "stars.h"
#include "special.h"
#include "cube.h"
#include "title.h"
#include "3d.h"
#include "particle.h"
#include "beetle.h"
#include "loadbin.h"
#include "loadjpeg.h"
#include "rotozoom.h"
#include "shiver.h"
#include "pvrutils.h"

extern char *credits[];
extern char scrolltext[];

//KOS 2.X: Replace unsigned int by pvr_ptr_t !!
extern pvr_ptr_t inter_tex;
extern pvr_ptr_t fire_tex;
extern pvr_ptr_t stars_tex;
extern pvr_ptr_t plasma_tex;
extern pvr_ptr_t special_tex;
extern pvr_ptr_t static_tex;
extern pvr_ptr_t font_tex;
extern pvr_ptr_t title_tex;
extern pvr_ptr_t particle_tex;
extern pvr_ptr_t br1_tex;
extern pvr_ptr_t br2_tex;
extern pvr_ptr_t br3_tex;
extern pvr_ptr_t br4_tex;
extern pvr_ptr_t y2k_tex;
extern pvr_ptr_t zoom512;
extern pvr_ptr_t zoom256;
extern pvr_ptr_t zoom128;
extern pvr_ptr_t zoom64;

int sprintf(char *buf, const char *fmt, ...);
int rand();
int randnum(int limit);
#endif
