#include "misc.h"

void bin_to_texture(char *filename, pvr_ptr_t tex, int w, int h)
{
    FILE *fd;
    unsigned short *temp_tex;
    
    temp_tex = (unsigned short *)malloc(w*h*2);

    fd = fopen(filename, "rb");
	if (fd){
		fseek(fd, 0, SEEK_END);
		unsigned long len = (unsigned long)ftell(fd);
		fseek(fd, 0, SEEK_SET);
		
		fread(temp_tex, 1, len, fd);
		fclose(fd);

		//Load and Twiddle Texture
		pvr_txr_load_ex(temp_tex, tex, w, h, PVR_TXRLOAD_16BPP); //Correct format is 16BITS!

		free(temp_tex);
	}
}
