#include "misc.h"

void font_init()
{
	font_tex = pvr_mem_malloc(512*512*2);
    bin_to_texture(FONT_FILE, font_tex, 512, 512);
}

void draw_char(float x1, float y1, float z1, float a, float r, float g, float b, int c, float xs, float ys) {
	pvr_vertex_t vert;

    int             ix, iy;
    float           u1, v1, u2, v2;
    
    ix = (c % 16) * 32;
    iy = (c / 16) * 48;
    u1 = ((float)(ix)+ 0.5f) / 512.0f;
    v1 = ((float)(iy) + 0.5f) / 512.0f;
    u2 = (ix+32) / 512.0f;
    v2 = (iy+48) / 512.0f;
    
    vert.flags = PVR_CMD_VERTEX;
    vert.x = x1;
    vert.y = y1 + 48.0f * ys;
    vert.z = z1;
    vert.u = u1;
    vert.v = v2;
	vert.argb = PVR_PACK_COLOR(a, r, g, b);
	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
   	pvr_prim(&vert, sizeof(vert));

    vert.x = x1;
    vert.y = y1;
    vert.u = u1;
    vert.v = v1;
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = x1 + 32.0f * xs;
    vert.y = y1 + 48.0f * ys;
    vert.u = u2;
    vert.v = v2;
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = x1 + 32.0f * xs;
    vert.y = y1;
    vert.u = u2;
    vert.v = v1;
	vert.flags = PVR_CMD_VERTEX_EOL;
	pvr_prim(&vert, sizeof(vert));
}

void draw_string(float x, float y, float z, float a, float r, float g, float b, char *str, float xs, float ys) {
  pvr_poly_cxt_t ctx;
  pvr_poly_hdr_t poly;
  
  pvr_poly_cxt_txr(&ctx, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB4444|PVR_TXRFMT_TWIDDLED, 512, 512, font_tex, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &ctx);
  pvr_prim(&poly, sizeof(poly));
  
  while (*str) {
    draw_char(x, y, z, a, r, g, b, *str++, xs, ys);
	x+=32*xs;
  }
}

int sinus_offset = 0;

void sinus_text(float x, float y, float z, float a, float r, float g, float b, char *str, float xs, float ys) {
  pvr_poly_cxt_t ctx;
  pvr_poly_hdr_t poly;
  
  pvr_poly_cxt_txr(&ctx, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB4444|PVR_TXRFMT_TWIDDLED, 512, 512, font_tex, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &ctx);
  pvr_prim(&poly, sizeof(poly));
  
  while ((*str) && (x < 640.0)) {
    draw_char(x, y + SIN((int)((x + sinus_offset) * 2))*10, z, a, r, g, b, *str++, xs, ys);
    x+=32*xs;
    sinus_offset = sinus_offset + 1;
  }
}

