#include "beetle_data.h"
#include "misc.h"

#define BEETLE_VERTEXES  334
#define BEETLE_UV        583
#define C1_TRIANGLES     150
#define C2_TRIANGLES      98
#define C3_TRIANGLES      61
#define C4_TRIANGLES     299
#define C5_TRIANGLES      64

float trans_coords[BEETLE_VERTEXES][4];

void beetle_init(void)
{
    int c;

    for(c=0; c<BEETLE_UV; c++)
	b_uv[c][1] = 1.0f - b_uv[c][1];

	br1_tex = pvr_mem_malloc(128*128*2);
    jpeg_to_texture(BR1_FILE, br1_tex, 128, 1);
	br2_tex = pvr_mem_malloc(128*128*2);
    jpeg_to_texture(BR2_FILE, br2_tex, 128, 1);
	br3_tex = pvr_mem_malloc(128*128*2);
    jpeg_to_texture(BR3_FILE, br3_tex, 128, 1);
	br4_tex = pvr_mem_malloc(128*128*2);
    jpeg_to_texture(BR4_FILE, br4_tex, 128, 1);
}

void draw_tri_col(float *p1, float *p2, float *p3, float a, float r, float g, float b)
{
	pvr_vertex_t vert;
    
	vert.argb = PVR_PACK_COLOR(r, g, b, a);
	vert.flags = PVR_CMD_VERTEX;
    
    vert.x = p3[0];
    vert.y = p3[1];
    vert.z = p3[3];
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = p2[0];
    vert.y = p2[1];
    vert.z = p2[3];
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = p1[0];
    vert.y = p1[1];
    vert.z = p1[3];
	vert.flags = PVR_CMD_VERTEX_EOL;
	pvr_prim(&vert, sizeof(vert));
}

void draw_tri_tex(float *p1, float *p2, float *p3, float *t1, float *t2, float *t3)
{
	pvr_vertex_t vert;
    
	vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
    vert.flags = PVR_CMD_VERTEX;
	
    vert.x = p3[0];
    vert.y = p3[1];
    vert.z = p3[3];
    vert.u = t3[0];
    vert.v = t3[1];
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = p2[0];
    vert.y = p2[1];
    vert.z = p2[3];
    vert.u = t2[0];
    vert.v = t2[1];
	pvr_prim(&vert, sizeof(vert));
    
    vert.x = p1[0];
    vert.y = p1[1];
    vert.z = p1[3];
	vert.flags = PVR_CMD_VERTEX_EOL;
    vert.u = t1[0];
    vert.v = t1[1];
	pvr_prim(&vert, sizeof(vert));
}

void draw_beetle(float x, float y, float z, int rx, int ry, int rz, float s)
{
	pvr_poly_cxt_t ctx;
	pvr_poly_hdr_t poly[5];
	
    int i;

    clear_matrix();
    apply_matrix(&screenview_matrix);
    apply_matrix(&projection_matrix);
    
    translate(x, y, z);

    rotate_x(rx);
    rotate_z(rz);
    rotate_y(ry);

    scale(s, s, s);

    transform_coords(b_coords, trans_coords, BEETLE_VERTEXES);

	pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 128, 128, br2_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly[0], &ctx);
	pvr_prim(&poly[0], sizeof(pvr_vertex_t));

    for(i=0; i<C1_TRIANGLES; i++)
      draw_tri_tex(trans_coords[b_coords1index[i*4]], trans_coords[b_coords1index[i*4+1]], trans_coords[b_coords1index[i*4+2]],b_uv[b_uv1index[i*4]],b_uv[b_uv1index[i*4+1]],b_uv[b_uv1index[i*4+2]]);

	pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 128, 128, br1_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly[1], &ctx);
	pvr_prim(&poly[1], sizeof(pvr_vertex_t));

    for(i=0; i<C2_TRIANGLES; i++)
      draw_tri_tex(trans_coords[b_coords2index[i*4]], trans_coords[b_coords2index[i*4+1]], trans_coords[b_coords2index[i*4+2]],b_uv[b_uv2index[i*4]],b_uv[b_uv2index[i*4+1]],b_uv[b_uv2index[i*4+2]]);

	pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 128, 128, br3_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly[2], &ctx);
	pvr_prim(&poly[2], sizeof(pvr_vertex_t));

    for(i=0; i<C3_TRIANGLES; i++)
      draw_tri_tex(trans_coords[b_coords3index[i*4]], trans_coords[b_coords3index[i*4+1]], trans_coords[b_coords3index[i*4+2]],b_uv[b_uv3index[i*4]],b_uv[b_uv3index[i*4+1]],b_uv[b_uv3index[i*4+2]]);

	pvr_poly_cxt_txr(&ctx, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 128, 128, br4_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly[3], &ctx);
	pvr_prim(&poly[3], sizeof(pvr_vertex_t));

    for(i=0; i<C5_TRIANGLES; i++)
      draw_tri_tex(trans_coords[b_coords5index[i*4]], trans_coords[b_coords5index[i*4+1]], trans_coords[b_coords5index[i*4+2]],b_uv[b_uv5index[i*4]],b_uv[b_uv5index[i*4+1]],b_uv[b_uv5index[i*4+2]]);

	pvr_poly_cxt_col(&ctx, PVR_LIST_OP_POLY);
	pvr_poly_compile(&poly[4], &ctx);

    for(i=0; i<C4_TRIANGLES; i++)
      draw_tri_col(trans_coords[b_coords4index[i*4]], trans_coords[b_coords4index[i*4+1]], trans_coords[b_coords4index[i*4+2]],1,0,0,0);

}

int beetle_orbit_r = 0;

void beetle_orbit(float x, float y, float z)
{
  draw_beetle(1.5f * SIN(beetle_orbit_r) + x , y , 1.5f * COS(beetle_orbit_r) + z, 0, 1024-beetle_orbit_r, 0, 0.01f);
  draw_beetle(1.5f * SIN(beetle_orbit_r+512) + x, y , 1.5f * COS(beetle_orbit_r+512) + z, 0, 512-beetle_orbit_r, 0, 0.01f);
  draw_beetle(1.5f * SIN(beetle_orbit_r+1024) + x, y , 1.5f * COS(beetle_orbit_r+1024) + z, 0, 2048-beetle_orbit_r, 0, 0.01f);
  draw_beetle(1.5f * SIN(beetle_orbit_r+1536) + x, y , 1.5f * COS(beetle_orbit_r+1536) + z, 0, 1536-beetle_orbit_r, 0, 0.01f);

  npm_cube_one_frame(1.5f * SIN(beetle_orbit_r+256) + x , y , 1.5f * COS(beetle_orbit_r+256) + z, beetle_orbit_r, 0.1f);
  npm_cube_one_frame(1.5f * SIN(beetle_orbit_r+768) + x, y , 1.5f * COS(beetle_orbit_r+768) + z, beetle_orbit_r, 0.1f);
  npm_cube_one_frame(1.5f * SIN(beetle_orbit_r+1280) + x, y , 1.5f * COS(beetle_orbit_r+1280) + z, beetle_orbit_r, 0.1f);
  npm_cube_one_frame(1.5f * SIN(beetle_orbit_r+1792) + x, y , 1.5f * COS(beetle_orbit_r+1792) + z, beetle_orbit_r, 0.1f);
 
  beetle_orbit_r += 3;

}

  



