#include "misc.h"

/* matrices for transforming world coordinates to
   screen coordinates (with perspective)        */

#define XCENTER 320.0
#define YCENTER 240.0

#define COT_FOVY_2 1.73 /* cot(FOVy / 2) */
#define ZNEAR 1.0
#define ZFAR  100.0

float screenview_matrix[4][4] = {
    { YCENTER,     0.0,   0.0,   0.0 },
    {     0.0, YCENTER,   0.0,   0.0 },
    {     0.0,     0.0,   1.0 ,  0.0 },
    { XCENTER, YCENTER,   0.0,   1.0 },
};

float projection_matrix[4][4] = {
    { COT_FOVY_2,         0.0,                        0.0,   0.0 },
    {        0.0,  COT_FOVY_2,                        0.0,   0.0 },
    {        0.0,         0.0,  (ZFAR+ZNEAR)/(ZNEAR-ZFAR),  -1.0 },
    {        0.0,         0.0,  2*ZFAR*ZNEAR/(ZNEAR-ZFAR),   1.0 },
};

void translate(float x, float y, float z)
{
    static float matrix[4][4] = {
	{ 1.0, 0.0, 0.0, 0.0 },
	{ 0.0, 1.0, 0.0, 0.0 },
	{ 0.0, 0.0, 1.0, 0.0 },
	{ 0.0, 0.0, 0.0, 1.0 },
    };

    matrix[3][0] = x;
    matrix[3][1] = y;
    matrix[3][2] = z;
    apply_matrix(&matrix);
}

void rotate_x(int n)
{
    static float matrix[4][4] = {
	{ 1.0, 0.0, 0.0, 0.0 },
	{ 0.0, 1.0, 0.0, 0.0 },
	{ 0.0, 0.0, 1.0, 0.0 },
	{ 0.0, 0.0, 0.0, 1.0 },
    };
    matrix[1][1] = matrix[2][2] = COS(n);
    matrix[1][2] = -(matrix[2][1] = SIN(n));
    apply_matrix(&matrix);
}

void rotate_y(int n)
{
    static float matrix[4][4] = {
	{ 1.0, 0.0, 0.0, 0.0 },
	{ 0.0, 1.0, 0.0, 0.0 },
	{ 0.0, 0.0, 1.0, 0.0 },
	{ 0.0, 0.0, 0.0, 1.0 },
    };
    matrix[0][0] = matrix[2][2] = COS(n);
    matrix[2][0] = -(matrix[0][2] = SIN(n));
    apply_matrix(&matrix);
}

void rotate_z(int n)
{
    static float matrix[4][4] = {
	{ 1.0, 0.0, 0.0, 0.0 },
	{ 0.0, 1.0, 0.0, 0.0 },
	{ 0.0, 0.0, 1.0, 0.0 },
	{ 0.0, 0.0, 0.0, 1.0 },
    };
    matrix[0][0] = matrix[1][1] = COS(n);
    matrix[0][1] = -(matrix[1][0] = SIN(n));
    apply_matrix(&matrix);
}

void scale(float x, float y, float z)
{
    static float matrix[4][4] = {
	{ 1.0, 0.0, 0.0, 0.0 },
	{ 0.0, 1.0, 0.0, 0.0 },
	{ 0.0, 0.0, 1.0, 0.0 },
	{ 0.0, 0.0, 0.0, 1.0 },
    };
    matrix[0][0] = x;
    matrix[1][1] = y;
    matrix[2][2] = z;
    apply_matrix(&matrix);
}
