/******************************************************************************
BINIAX SOUND-RELATED DEFINITIONS
COPYRIGHT JORDAN TUZSUZOV, (C) 2005.
******************************************************************************/

#ifndef _BNX_SND_H
#define _BNX_SND_H

/******************************************************************************
INCLUDES
******************************************************************************/

#include <SDL_mixer.h>

#include "inc.h"

/******************************************************************************
CONSTANTS
******************************************************************************/

enum _BNX_Sounds {
	cSndNone =	0,
	cSndTake,
	cSndFail,
	cSndScroll,
	cSndShake,
	cSndLast,
};

/******************************************************************************
LOCAL SOUND DATA (WAV SAMPLES, ETC.)
******************************************************************************/

typedef struct BNX_SND {

	Mix_Chunk *sounds[ cSndLast ];

} BNX_SND;

/******************************************************************************
FUNCTIONS
******************************************************************************/

BNX_BOOL sndInit();

void sndUpdate();

void sndPlay( BNX_GAME *game );

//void sndPlay( BNX_INT16 index );

#endif
