/******************************************************************************
BINIAX INPUT-RELATED IMPLEMENTATIONS
COPYRIGHT JORDAN TUZSUZOV, (C) 2005.
******************************************************************************/

/******************************************************************************
INCLUDES
******************************************************************************/

#include <stdlib.h>

#include "inc.h"

BNX_BOOL dcsaveGame( BNX_GAME *game );
BNX_BOOL dcloadGame( BNX_GAME *game );
BNX_BOOL dcsaveHiScore( BNX_GAME *game );
BNX_BOOL dcloadHiScore( BNX_GAME *game );
/******************************************************************************
FUNCTIONS
******************************************************************************/

cont_state_t* state; 
maple_device_t* dev;

BNX_BOOL inpInit()
{
	dev = maple_enum_dev (0,0);
	_Inp.keyUp		= BNX_FALSE;
	_Inp.keyDown	= BNX_FALSE;
	_Inp.keyLeft	= BNX_FALSE;
	_Inp.keyRight	= BNX_FALSE;
	_Inp.keyA		= BNX_FALSE;
	_Inp.keyB		= BNX_FALSE;

	return BNX_TRUE;
}

void inpUpdate()
{

		state = (cont_state_t*) maple_dev_status (dev);

		if(state->buttons & CONT_A)
			_Inp.keyA		= BNX_TRUE;
		if(state->buttons & CONT_B)
			_Inp.keyB		= BNX_TRUE;

		//KOS 2.X Note: Maple joyx / joyy are all 0 based (0 is centered)
		//But we'll disable here, only d-pad
		if((state->buttons & CONT_DPAD_UP)){
			_Inp.keyUp		= BNX_TRUE;
		}
		else if((state->buttons & CONT_DPAD_DOWN)){
			_Inp.keyDown	= BNX_TRUE;
		}
		else if((state->buttons & CONT_DPAD_LEFT)){
			_Inp.keyLeft	= BNX_TRUE;
		}
		else if((state->buttons & CONT_DPAD_RIGHT)){
			_Inp.keyRight	= BNX_TRUE;
		}
		
		thd_sleep(80);
}

BNX_BOOL inpKeyLeft()
{
	if ( _Inp.keyLeft == BNX_TRUE )
	{
		_Inp.keyLeft = BNX_FALSE;
		return BNX_TRUE;
	}

	return BNX_FALSE;
}

BNX_BOOL inpKeyRight()
{
	if ( _Inp.keyRight == BNX_TRUE )
	{
		_Inp.keyRight = BNX_FALSE;
		return BNX_TRUE;
	}

	return BNX_FALSE;
}

BNX_BOOL inpKeyUp()
{
	if ( _Inp.keyUp == BNX_TRUE )
	{
		_Inp.keyUp = BNX_FALSE;
		return BNX_TRUE;
	}

	return BNX_FALSE;
}

BNX_BOOL inpKeyDown()
{
	if ( _Inp.keyDown == BNX_TRUE )
	{
		_Inp.keyDown = BNX_FALSE;
		return BNX_TRUE;
	}

	return BNX_FALSE;
}

BNX_BOOL inpKeyA()
{
	if ( _Inp.keyA == BNX_TRUE )
	{
		_Inp.keyA = BNX_FALSE;
		return BNX_TRUE;
	}

	return BNX_FALSE;
}

BNX_BOOL inpKeyB()
{
	if ( _Inp.keyB == BNX_TRUE )
	{
		_Inp.keyB = BNX_FALSE;
		return BNX_TRUE;
	}

	return BNX_FALSE;
}

/******************************************************************************
GAME AND HISCORE SAVE / RESTORE
******************************************************************************/
BNX_BOOL dcsaveGame( BNX_GAME *game )
{
	file_t		f;
	
	f = fs_open( "/vmu/a1/autosave.bnx", O_WRONLY );

	if ( !f )
		return BNX_FALSE;

	BNX_UINT16 i;
	BNX_UINT8 buffer[4];
	//start of the header 
	fs_write(f, "Biniax          ", 16);         //vmdesc 
	fs_write(f, "Save Game                       ", 32);   //dcdesc 
	fs_write(f, "Biniax          ", 16);         //appname 

	buffer[0]=1; 
	buffer[1]=0; 
	fs_write(f, buffer, 2);               //icons num 
	fs_write(f, buffer, 2);               //anim speed 

	buffer[0] = 0; 
	fs_write(f, buffer, 2);               //eyecatch 
	fs_write(f, buffer, 2);               //crc 

	buffer[0]=0; 
	buffer[1]=0; 
	buffer[2]=0; 
	buffer[3]=0; 
	fs_write(f, buffer, 4);               //data length 

	buffer[0] = 0;

	for (i=0; i<20; i+=2) 
		fs_write(f, buffer, 2);            //reserved

	for (i=0; i<16; i++) { 
		fs_write(f, buffer, 2);            //icons pal 
	} 

	for (i=0; i<256; i++) { 
		fs_write(f, buffer, 2);            //icons bitmap 
	} 

	//actual content start here 
	fs_write(f, game,  sizeof( BNX_GAME )); 

	fs_close( f );

	return BNX_TRUE;
}

BNX_BOOL dcloadGame( BNX_GAME *game )
{
	file_t		f;
	
	f = fs_open( "/vmu/a1/autosave.bnx", O_RDONLY );

	if ( !f )
		return BNX_FALSE;

	fs_seek(f, 640, SEEK_SET); 
	fs_read(f, game, sizeof( BNX_GAME )); 
	fs_close(f);	

	return BNX_TRUE;
}

BNX_BOOL dcsaveHiScore( BNX_GAME *game )
{
	BNX_INT32	test;
	file_t		f;
	
	f = fs_open( "/vmu/a1/highscore.bnx", O_WRONLY );

	if ( !f )
		return BNX_FALSE;

	BNX_UINT16 i;
	BNX_UINT8 buffer[4];
	//start of the header 
	fs_write(f, "Biniax          ", 16);         //vmdesc 
	fs_write(f, "High Score Data                 ", 32);   //dcdesc 
	fs_write(f, "Biniax          ", 16);         //appname 

	buffer[0]=1; 
	buffer[1]=0; 
	fs_write(f, buffer, 2);               //icons num 
	fs_write(f, buffer, 2);               //anim speed 

	buffer[0] = 0; 
	fs_write(f, buffer, 2);               //eyecatch 
	fs_write(f, buffer, 2);               //crc 

	buffer[0]=0; 
	buffer[1]=0; 
	buffer[2]=0; 
	buffer[3]=0; 
	fs_write(f, buffer, 4);               //data length 

	buffer[0] = 0;

	for (i=0; i<20; i+=2) 
		fs_write(f, buffer, 2);            //reserved

	for (i=0; i<16; i++) { 
		fs_write(f, buffer, 2);            //icons pal 
	} 

	for (i=0; i<256; i++) { 
		fs_write(f, buffer, 2);            //icons bitmap 
	} 

	//actual content start here 
	test = game->best + 1;
	fs_write(f, &game->best,  sizeof( game->best )); 
	fs_write(f, &test,  sizeof( test )); 

	fs_close( f );

	return BNX_TRUE;
}

BNX_BOOL dcloadHiScore( BNX_GAME *game )
{
	BNX_INT32	test;
	file_t		f;
	
	f = fs_open( "/vmu/a1/autosave.bnx", O_RDONLY );

	if ( !f )
		return BNX_FALSE;

	fs_seek(f, 640, SEEK_SET); 
	fs_read(f, &game->best, sizeof( game->best )); 
	fs_read(f, &test, sizeof( game->best )); 
	if ( test-1 != game->best )
	{
		game->best = 0;
		fs_close(f);
		return BNX_FALSE;
	}
	fs_close(f);	

	return BNX_TRUE;

}
