/***************************************************************************
 *   Copyright (C) 2007 by Xavier Sala                                     *
 *   utrescu@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "disparador.h"
#include <SDL_image.h>
#include <SDL_rotozoom.h>

Disparador::Disparador(SDL_Rect p, char *nom)
{
	Posicio = p;
	Imatge = IMG_Load(nom);
	Posicio.w = Imatge->w;
	Posicio.h = Imatge->h;
	Posicio.x = (Posicio.x - Imatge->w)/2;
	Posicio.y = (SDL_GetVideoSurface()->h - Imatge->h);
	angle = PI/2;
}


Disparador::~Disparador()
{
	SDL_FreeSurface(Imatge);
}

// Gira()
//
// Canvia l'angle del disparador en el valor
// especificat. Només permeto angles que vagin
// des de 0 a PI (no inclosos).
// L'angle és en radiants
void Disparador::Gira(float inc)
{
	if (angle + inc < 0.1)
	{
		angle = 0.1;
	} else if (angle + inc > (PI-0.1))
	{
		angle=(PI-0.1);
	} else
	{
		angle += inc;
	}
	
}

// Pinta()
//
// Pinta la imatge del disparador girada tants de graus
// com espefiqui l'angle
// 
// Pel rotozoom l'angle ha de ser en graus i per tant s'ha de convertir.
void Disparador::Pinta(SDL_Surface* p)
{
	SDL_Rect origen, desti; 
	SDL_Surface *nova = rotozoomSurface(Imatge, angle*CONVERSIO, 1.0, 1);
	// Com que el rotozoom modifica la mida de les imatges, la posiciono 
	// de nou basant-me en les seves coordenades centrals	
	desti.x = (p->w - nova->w)/2;
	desti.y = Posicio.y + (Imatge->h *0.5) - (nova->h*0.5);

	desti.w = nova->w;
	desti.h = nova->h;
#ifdef DEBUG
	printf("Origen:%d --> Ara:%dx Imatge:%d\n",Posicio.y, desti.y, nova->h);
#endif
	// SDL_FillRect(p,&desti,0x000000);
	SDL_BlitSurface(nova,NULL,p,&desti);
	SDL_FreeSurface(nova);
}
	

