/***************************************************************************
 *   Copyright (C) 2007 by Xavier Sala                                     *
 *   utrescu@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BOLA_H
#define BOLA_H

#include <SDL.h>
#include <vector>

#define VELOCITAT 30
/**
	@author Xavier Sala <utrescu@gmail.com>
*/



class Bola{

	// Número de bola
	int ID;
	
	static int Matricula;

	// Posició de la bola
	SDL_Rect Posicio;
	float x, y;
	// Moviment de la bola (x,y) i variable per dir que s'està movent
	float velocitatx, velocitaty;
	bool Moventse;
	// Color de la bola
	int Color;
	// Llista de les boles amb les que aquesta xoca
	std::vector<Bola*> XocoAmb;
	// Amb quantes boles del mateix color xoquem
	int XocoAmbMateixColor;
	// Determina si aquesta bola està eliminada
    	bool Eliminada;
	// Determina si la bola està penjant
	bool Penjant;

// ------ Comprovar els xocs i tractament (privat)
	Uint32 GetPixel(SDL_Surface *surface, int x, int y);
    	void EliminarXoc(Bola* b);
    	void TreureXocs();
    	int XocsDelColor() { return XocoAmbMateixColor; }

public:
    	Bola(SDL_Rect n, int color);

// ----- Característiques de la bola
	int getID() { return ID; }
    	SDL_Rect getPosicio();
    	int getColor() { return Color; }
    	void BolaADalt();
    	bool isBolaADalt();

// ----- Bola en moviment
    	void Dispara(float angle);
    	void Mou();
    	void Atura();
    	bool EnMoviment();
    	void Rebota() { velocitatx *=-1; }

// ------ Comprovar els xocs i tractament
    	bool Tocat(SDL_Rect impacte);
    	void AfegirXoc(Bola* b);
    	bool TestEliminacio();
    	void BolaEliminada();
    	bool EstaEliminada() { return Eliminada; }

// ------ Per saber si penja d'un lloc vàlid
	bool Penja(bool t) { Penjant=t; }
	bool EstaPenjant() { return Penjant; }
	void MarcaPenjades();


    	~Bola();

};

#endif
