/***************************************************************************
 *   Copyright (C) 2007 by Xavier Sala                                     *
 *   utrescu@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifdef WIN32
#include "stdafx.h"
#pragma comment(lib, "SDL.lib")
#pragma comment(lib, "SDLmain.lib")
#pragma comment(lib, "SDL_gfx.lib")
#endif

#define NUMEROBOLES 6
#define MOVIMENTANGLE 0.1

#include <SDL.h>
#include <SDL_image.h>
#include <vector>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "bola.h"
#include "disparador.h"

#ifdef DREAMCAST
#include <kos.h>
#include <SDL/SDL_dreamcast.h>
KOS_INIT_FLAGS(INIT_DEFAULT);
#endif

SDL_Surface *pantalla, *imatge;
std::vector <Bola*> boles;
Disparador *bang;
SDL_Surface *DibuixBoles[NUMEROBOLES];
char *NomImatges[NUMEROBOLES]={"vermella.png","verda.png","groga.png","blava.png","lila.png","blanca.png"};
int HiHaBola[NUMEROBOLES]={0, 0, 0, 0, 0, 0 };

int nivellactual = 0;

// Uint32 GetPixel(SDL_Surface *surface, int x, int y)
//
// Diu de quin color és el pixel determinat
//
Uint32 GetPixel(SDL_Surface *surface, int x, int y)
{
    int bpp = surface->format->BytesPerPixel;
    // Calcular l'adre�a del pixel
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp) {
    case 1:
        return *p;

    case 2:
        return *(Uint16 *)p;

    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
            return p[0] << 16 | p[1] << 8 | p[2];
        else
            return p[0] | p[1] << 8 | p[2] << 16;

    case 4:
        return *(Uint32 *)p;

    default:
        return 0;
    }
}

// bool Tocat(SDL_Rect qui1, SDL_Rect qui2, SDL_Rect impacte, int quinaImatge)
//
// Comprova amb detall si les boles xoquen o no ho fan.
// Retorna CERT si xoca i FALS si no
//
bool Tocat(SDL_Rect qui1, SDL_Rect qui2, SDL_Rect impacte, int quinaImatge)
{
	int i, i2, j, j2;
	Uint32 blanc;
	bool retorn = false;
	// On comença l'impacte en el primer cercle
	int principix=impacte.x-qui1.x;
	int principiy=impacte.y-qui1.y;
	// On comença l'impacte en el segon cercle
	int principix2 = impacte.x - qui2.x;
	int principiy2 = impacte.y - qui2.y;
	
	// Obtenir un exemple del color transparent
	blanc=GetPixel(DibuixBoles[quinaImatge], 0, 0);

	SDL_LockSurface(DibuixBoles[quinaImatge]);
	i=principix;
	i2 = principix2;
	while(i<principix+impacte.w && retorn==false)
	{
		j=principiy;
		j2=principiy2;
		while (j<principiy+impacte.h && retorn==false)
		{
			// Si un no es blanc, llavors pleguem...
			if (GetPixel(DibuixBoles[quinaImatge], i, j)!=blanc && 
			    GetPixel(DibuixBoles[quinaImatge],i2,j2)!=blanc ) 
			{
				retorn=true;
			}
			j++;
			j2++;
		}
		i++;
		i2++;
	}
	SDL_UnlockSurface(DibuixBoles[quinaImatge]);
	
	return retorn;
}

// bool IntersectRect(SDL_Rect *dest,const SDL_Rect *src1,const SDL_Rect *src2)
//
// Comprova si els rectangles src1 i src2 xoquen i ens dóna el rectangle de 
// xoc a dest.
//
bool IntersectRect(SDL_Rect *dest,const SDL_Rect *src1,const SDL_Rect *src2)
{
  int px0,py0,px1,py1;
  int cx0,cy0,cx1,cy1;
  int rx0,ry0,rx1,ry1;
  
  // Emplena per defecte (NULL) el rectangle resultant

  dest->x = 0;
  dest->y = 0;
  dest->w = 0;
  dest->h = 0;
  
  // obté coordenades dels rectangles

  px0 = src1->x;
  py0 = src1->y;
  px1 = src1->x + src1->w - 1;
  py1 = src1->y + src1->h - 1;
  
  cx0 = src2->x;
  cy0 = src2->y;
  cx1 = src2->x + src2->w - 1;
  cy1 = src2->y + src2->h - 1;
  
  // comprova si els rectangles intersecten

  if(/*(cx0 < px0) && */(cx1 < px0))
    return false;
  
  if((cx0 > px1) /*&& (cx1 > px1)*/)
    return false;
  
  if(/*(cy0 < py0) && */(cy1 < py0))
		return false;
  
  if((cy0 > py1) /*&& (cy1 > py1)*/)
    return false;
  
  // intersecta x

  if(cx0 <= px0) rx0 = px0;
  else rx0 = cx0;
  
  if(cx1 >= px1) rx1 = px1;
  else rx1 = cx1;
  
  // intersecta y

  if(cy0 <= py0) ry0 = py0;
  else ry0 = cy0;
  
  if(cy1 >= py1) ry1 = py1;
  else ry1 = cy1;
  
  // emplena el rectangle resultant

  dest->x = rx0;
  dest->y = ry0;
  dest->w = (rx1-rx0)+1;
  dest->h = (ry1-ry0)+1;

return true;
};


// Purga()
//
// Determinem quines boles són les que no estan penjant
// del sostre
//
// Això es fa perquè aquestes també s'han d'eliminar
void Purga()
{
	int i;
	// Posar-los tots a fals menys la que hem de tirar perquè 
	// aquesta no cal que la comprovem perquè segur que no penja
	// del sostre i per tant no l'hem de comprovar.
	// ** Per defecte les boles es creen pensant que penjen del sostre
	for(i=0; i<boles.size()-1; i++)
	{
		boles[i]->Penja(false);
	}
	// Ara determinar quines penjen del sostre
	for(i=0; i<boles.size(); i++)
	{
		// Per marcar les altres boles, només comencem per les que són a dalt de tot
		// i evidentment que no estiguin marcades com eliminades
		if (boles[i]->isBolaADalt() && boles[i]->EstaEliminada()==false)
		{
			boles[i]->MarcaPenjades();
		}
	}
}

// RecompteINeteja()
//
// Compta les boles que tenim de cada color i elimina les que estan 
// marcades com eliminades i les que no penjen del sostre
//
// Comptem les boles que hi ha de cada color per evitar que surtin
// colors que ja no hi són
int RecompteINeteja()
{
	int i=0;
	int total=0;
	// Iniciar a zero
	for(i=0; i<NUMEROBOLES; i++)
	{
		HiHaBola[i]=0;
	}
	// Comptar les boles que hi ha de cada color i de pas eliminem les que 
	// tinguin marques d'eliminades

	printf("Boles abans: %d\n",boles.size());

	std::vector<Bola*>::iterator it = boles.begin();
	while(it!=boles.end())
	{
		// Si no penja i no es mou s'ha d'eliminar
		// les que es mouen no perquè evidentment estan penjant sempre :-)
		if ((*it)->EstaPenjant()==false && (*it)->EnMoviment()==false)
		{
			(*it)->BolaEliminada();
 			printf("\n");

			boles.erase(it);
		}
		else
		{
			// Les que estan eliminades s'han d'esborrar del vector
			if ((*it)->EstaEliminada()==true)
			{
				boles.erase(it);
			}
			else
			{
				// Només s'han de comptar les que no s'han d'eliminar
				HiHaBola[(*it)->getColor()]++;
				total++;
				it++;
			}
		}
	}
	printf("Boles despres: %d\n",boles.size());

	return total;
}

// SeleccionaBola()
//
// Tria una bola d'entre les que hi ha per pantalla i la
// que està per tirar
//
int SeleccionaBola()
{
	int tria;
	
	do{
		tria = rand()%NUMEROBOLES;
	} while(HiHaBola[tria]<=0);

	return tria;
}

// NovaBola()
//
// Crea una bola en la posició de sortida
// i la tria dels colors que estigui en pantalla
//
void NovaBola()
{
	int col;
	SDL_Rect temp;

	col = SeleccionaBola();
	temp.x = (pantalla->w - DibuixBoles[col]->w)/2;
	temp.y = (pantalla->h - DibuixBoles[col]->h);
	temp.w = DibuixBoles[col]->w;
	temp.h = DibuixBoles[col]->h;
	boles.push_back(new Bola(temp,col));
	// Portar el compte de les boles
	HiHaBola[col]++;
}

// CalculaXocsInicials(SDL_Rect tmp)
//
// Per comprovar les boles de la pantalla
// que es carreguen inicialment
//
void CalculaXocsInicials(SDL_Rect tmp1)
{
	SDL_Rect tmp, tmp2; 
	int ultima = boles.size()-1;

	printf("..Bola %d:",boles[ultima]->getID());

	for (int i=0; i<boles.size()-1; i++)
	{
		tmp2 = boles[i]->getPosicio();
		if (IntersectRect(&tmp,&tmp2,&tmp1)==true)
		{
			// 2a. Fase: Ara refinar el toc i si xoca l'aturem!
			// XOCS
			printf("..Xoca amb %d",boles[i]->getID());
			boles[i]->AfegirXoc(boles[ultima]);
			boles[ultima]->AfegirXoc(boles[i]);
		}
	}
	printf("\n");
}

// CarregaPantalla()
//
// Intenta carregar un nivell llegint el fitxer de text.
// Si no el troba, el joc s'acaba :(
int CarregaPantalla(int nivell)
{
	SDL_Rect temp;
	int col, res;
	char tmpx[4], tmpy[4], tmpc[3];
	char FitxerACarregar[80];

	sprintf(FitxerACarregar,"pantalla%d.txt",nivell);
	FILE *fp = fopen(FitxerACarregar,"r");
	if (fp==NULL)
	{
		printf("Error no trobo el fitxer!\n");
		return -1;
	}
	
	int TotalBoles = 0;
	while ( (res = fscanf(fp, "%s %s %s",tmpx, tmpy, tmpc))>0)
	{
		temp.x = atoi(tmpx);
		temp.y = atoi(tmpy);
		col = atoi (tmpc);
		temp.w = DibuixBoles[col]->w;
		temp.h = DibuixBoles[col]->h;
		boles.push_back(new Bola(temp, col));
		HiHaBola[col]++;
		TotalBoles++;
		CalculaXocsInicials(temp);
	}

	fclose (fp);
	return TotalBoles;
}

// Neteja()
//
// Elimina totes les boles existents, per poder resetejar el joc
void Neteja()
{
	// Recorrem el vector i les eliminem totes!
	std::vector<Bola*>::iterator it = boles.begin();
	while(it!=boles.end())
	{
		(*it)->BolaEliminada();
		boles.erase(it);
	}
}

void FreeResources()
{
	//Alliberem memòria
	for (int i=0; i<NUMEROBOLES; i++) SDL_FreeSurface(DibuixBoles[i]);
	delete bang;
}

void repintar()
{
	SDL_FillRect(pantalla,NULL,0xFFFFFF);

	bang->Pinta(pantalla);
	// Ensenyar les boles per pantalla
	for (int i=0; i<boles.size(); i++)
	{
		int col = boles[i]->getColor();
	
		// Pintar només les que no són del color
		if (!boles[i]->EstaEliminada())
		{
			SDL_Rect tmp1 = boles[i]->getPosicio();
			// SDL_FillRect(pantalla,&tmp1,0x000000);
			SDL_BlitSurface(DibuixBoles[col],NULL,pantalla,&tmp1);
		}
	}

}

int main(int argc, char **argv)
{	

	#ifdef DREAMCAST
	fs_chdir("/cd/game");
	#endif

	int bolaActual;
	float velocitat=0.0;
	char FitxerACarregar[80];
	int TotalBoles = 0;

	/* inicialitza SDL */
	if ( SDL_Init( SDL_INIT_VIDEO | SDL_INIT_JOYSTICK ) < 0 )
	{
		fprintf( stderr, "Video initialization failed: %s\n",
		SDL_GetError( ) );
		SDL_Quit( );
	}

	atexit(SDL_Quit);
	

	pantalla = SDL_SetVideoMode(640, 480, 32, SDL_HWSURFACE|SDL_DOUBLEBUF);
	if ( pantalla == NULL ) 
	{ 
		printf("Unable to set 640x480 video: %s\n",SDL_GetError()); 
		return 1;
	} 

	srand( (unsigned)time( NULL ) );

	SDL_Event event;
	
	//Dreamcast: Defineix els controls
	#ifdef DREAMCAST
	SDL_DC_MapKey(0,SDL_DC_UP,SDLK_UP); 
	SDL_DC_MapKey(0,SDL_DC_DOWN,SDLK_DOWN); 
	SDL_DC_MapKey(0,SDL_DC_LEFT,SDLK_LEFT); 
	SDL_DC_MapKey(0,SDL_DC_RIGHT,SDLK_RIGHT);
	SDL_DC_MapKey(0,SDL_DC_A,SDLK_UP);
	SDL_DC_MapKey(0,SDL_DC_B,SDLK_w); //previous
	SDL_DC_MapKey(0,SDL_DC_Y,SDLK_q); //next
	SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L button
	
	SDL_JoystickEventState(SDL_ENABLE);
	SDL_JoystickOpen(0); 	
	SDL_DC_EmulateMouse(SDL_bool (false));
	SDL_ShowCursor(0);
	
	SDL_Delay(20);
	while(SDL_PollEvent(&event))
		SDL_Delay(20);
	#endif
	
	// 1. Carregar totes les boles i els dibuixos que facin falta
	for(int i=0; i<NUMEROBOLES; i++)
	{
		sprintf(FitxerACarregar,"%s",NomImatges[i]);
		printf("%s\n",FitxerACarregar);
		DibuixBoles[i] = IMG_Load(FitxerACarregar);
		SDL_SetColorKey(DibuixBoles[i],SDL_SRCCOLORKEY,SDL_MapRGB(DibuixBoles[i]->format, 255,255,255));
	}
	// Crear el disparador ... 
	SDL_Rect r;
	r.x = pantalla->w;
	r.y = pantalla->h;
	sprintf(FitxerACarregar,"disparador.png");
	bang = new Disparador(r,FitxerACarregar);

while (1) {

	// 2. Carregar el fitxer de text amb les posicions de les boles
	// estan en format: posiciox posicioy color
	TotalBoles = CarregaPantalla(nivellactual);

	if (TotalBoles == -1){
		//No hi ha més nivells, game over!
		FreeResources();
		return 0;
	}

	// 3. Crear una bola i posar-la al mig de la pantalla i amb un dels
	// colors que estiguin a la pantalla
	NovaBola();
	TotalBoles++;
	bool inici = true; //repintar tot!

	// 4. Bucle principal.
	// El nivell s'acabarà quan només quedi una sola bola (que és la que 
	// hem de tirar ... )
	while (TotalBoles>1)
	{
		//Comprovem primer si hi ha moviment continu del teclat per girar
		Uint8 * keystate = SDL_GetKeyState(NULL);
		if(keystate[SDLK_LEFT]){
			// ---- A L'ESQUERRA! ----------------
			bang->Gira(MOVIMENTANGLE);
		}
		else if(keystate[SDLK_RIGHT]){
			// ---- A LA DRETA --------------------
			bang->Gira(-MOVIMENTANGLE);
		} 
		
		while ( SDL_PollEvent(&event))
		{
			switch (event.type)
			{
				case SDL_QUIT:
					// Si tanquen la finestra poso les boles a zero
					TotalBoles = 0;
					FreeResources();
					return 0;
					break;
				case SDL_KEYDOWN:
					switch(event.key.keysym.sym)
					{
						case SDLK_ESCAPE:
							// Hem d'acabar, per tant boles a zero
							TotalBoles = 0;
							FreeResources();
							return 0;
							break;
						case SDLK_UP:
							// ----- DISPARA! ------------------
							// Com que les afegeixo al final, sempre 
							// tindré la bola amb la que jugo en darrer lloc
							bolaActual = boles.size()-1;
							boles[bolaActual]->Dispara(bang->getAngle());
							
							NovaBola();
							TotalBoles++;
							
							break;					
						case SDLK_LEFT:
							break;
						case SDLK_RIGHT:
							break;
						case SDLK_q:
							//Previous Level!
							nivellactual--;
							if (nivellactual < 0) nivellactual = 0;
							TotalBoles = 0;
							break;
						case SDLK_w:
							//Next Level!
							nivellactual++;
							TotalBoles = 0;
							break;
					}
					break;
			}
		}
		
	// ------------------- MOURE TOT EL QUE S'HA DE MOURE --------------------------------

		
		// Moure les boles
		SDL_Rect tmp, tmp1, tmp2;

		for (int i=0; i<boles.size(); i++)
		{
			// Només movem les boles que estan en moviment i no estan eliminades
			// -- No estic segur que calgui comprovar si està eliminada perquè ara les
			// -- elimino del vector
			if (boles[i]->EnMoviment() && !boles[i]->EstaEliminada())
			{

				//La borrem de pantalla (repintar de blanc)
				tmp = boles[i]->getPosicio();
				SDL_BlitSurface(DibuixBoles[NUMEROBOLES-1],NULL,pantalla,&tmp);

				boles[i]->Mou();
				tmp1 = boles[i]->getPosicio();
				// ---- Rebot als costats -------
				if (tmp1.x<=0 || tmp1.x+tmp1.w > pantalla->w) boles[i]->Rebota();
				// ---- Sóc a dalt, per tant s'ha d'aturar --------------
				if (tmp1.y<=0)
				{
					boles[i]->BolaADalt();
				}

				//I la mostrem en la nova posició :)
				int col = boles[i]->getColor();
				SDL_BlitSurface(DibuixBoles[col],NULL,pantalla,&tmp1);

				// Comprova si xoca amb una altra bola i si xoca aturar-la...
				// S'ha de comprovar amb totes
				for(int j=0; j<boles.size()-1; j++)
				{
					// Saltar-se les boles que estan eliminades (crec que ara ja no cal)
					if (!boles[j]->EstaEliminada())
					{
						// Només miro les que no s'estan movent per evitar que xoquin 
						// entre elles les boles que tiro jo.
						// 
						// i evidentment que no compari amb ella mateixa
						if (i!=j && boles[j]->EnMoviment()==false)
						{
							tmp2 = boles[j]->getPosicio();
							
							// ----------------- COMPROVAR SI XOQUEN LES BOLES EN FASES ------------------
							// 1a. Fase: Miro si xoquen els rectangles de les dues boles... 
							// .. tmp1 és la que acaba de tocar
							// .. tmp2 és una d'aturada
							// .. tmp serà el rectangle de xoc
							if (IntersectRect(&tmp,&tmp2,&tmp1)==true)
							{
								// 2a. Fase: Ara refinar el toc i si xoca l'aturem!
								// aquesta fase la faig perquè pot ser que xoquin els requadres i en canvi
								// no xoquin els dibuixos, per això afinem una mica més.
								if (Tocat(tmp1, tmp2,tmp,0))
								{
									// Si ha xocat, la bola s'ha d'aturar
									boles[i]->Atura();
									// Avisem a les dues boles de que xoquen entre elles
									// perquè després això es farà servir per eliminar les
									// boles del mateix color.
									boles[i]->AfegirXoc(boles[j]);
									boles[j]->AfegirXoc(boles[i]);
									// Ara que sabem segur que han xocat hem de comprovar si 
									// hem xocat amb tres boles del mateix color o més.
									// Si passa això, les boles han de desaparèixer. 
									// La funció TestEliminació() marca les boles que s'han 
									// d'eliminar
									// Si n'ha marcat alguna tornarà cert
									if (boles[i]->TestEliminacio()==true)
									{
										// Procés que marca les boles que no penjen del
										// sostre. Que també s'han d'eliminar
										Purga();

										// Com que se n'han eliminat, tornem a comptar 
										// quantes boles tenim i fem neteja de les boles
										// marcades com eliminades i no penjades de dalt
										TotalBoles = RecompteINeteja();

										//Repintar tot!
										repintar();

									}
								}
							}
							// ---------------- FINAL DE LA COMPROVACIÓ DEL XOC DE LES BOLES -------------
						}
					}
				}
			}
		}
		
	// Només cal pintar tot al principi d'un nivell.
	// Al eliminar les boles, simplement pintarem l'espai de les boles en blanc!
	// Sempre caldrà pintar el disparador i la bola en el disparador :)

		if (inici){

	// Un cop he mogut tot el que s'ha de moure, toca pintar-ho tot tal com ha quedat...
	// ------------------- PINTAR-HO TOT -------------------------------
			repintar();
			inici = false;
		}
		else{

			bang->Pinta(pantalla);
			// Última bola
			int col = boles[boles.size()-1]->getColor();
			SDL_Rect tmp = boles[boles.size()-1]->getPosicio();
			SDL_BlitSurface(DibuixBoles[col],NULL,pantalla,&tmp);
		}

	// Ara ja podem mostrar la pantalla		
		SDL_Flip(pantalla);
	}

	// Acabat el nivell
	printf("ACABAT: %d boles\n",TotalBoles);

	//Eliminem totes les boles!
	Neteja();

}
	
	return 0;
}
