/***************************************************************************
 *   Copyright (C) 2007 by Xavier Sala                                     *
 *   utrescu@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "bola.h"
#include <math.h>

#define DEBUG

int Bola::Matricula=0;


// Constructor
//
Bola::Bola(SDL_Rect n, int color)
{
	ID = ++Matricula;
	Posicio = n;
	Color = color;
	x = Posicio.x;
	y = Posicio.y;
	velocitatx=0;
	velocitaty=0;
	Moventse=false;
	Eliminada=false;
	Penjant=true;
	XocoAmbMateixColor=0;
}


Bola::~Bola()
{
}

//  Mou()
//
// Mou la bola en la direcció que s'hagi
// estipulat en el Dispara()
void Bola::Mou()
{
	x+=velocitatx;
	y+=velocitaty;
}

// BolaADalt()
//
// Posiciona la bola a dalt de tot. Si 
// ens hem passat la recol·loca a la posició
// y=0.
void Bola::BolaADalt()
{
	y=0;
	Atura();
}

// isBolaADalt()
//
// Ens diu si la bola està a dalt de tot
// o no
//
// La idea és que aquestes tenen un xoc 
// mínim
bool Bola::isBolaADalt()
{
	Posicio.y=y;
	return (Posicio.y==0);
}


// getPosicio()
// 
// Retorna un SDL_Rect amb la posició de la bola
// Obté les coordenades de x,y perquè necessitàvem
// que la posició estés en variables float per poder 
// donar angles diversos
SDL_Rect Bola::getPosicio()
{
	Posicio.x = x;
	Posicio.y = y;
	return Posicio;
}


// Atura()
//
// Fa que la bola deixi de moure's
void Bola::Atura()
{
	velocitatx=0;
	velocitaty=0;
	Moventse=false;
}

// Dispara()
//
// Indica a la bola que a partir d'ara s'haurà
// de moure en la direcció especificada per
// l'angle
void Bola::Dispara(float angle)
{
	velocitatx = VELOCITAT * cos(angle);
	velocitaty = VELOCITAT * -sin(angle);
	Moventse=true;
}

// EnMoviment()
//
// Ens informa de si la bola està en moviment o no
//
// Això es fa servir per evitar comparacions innecessàries
//
bool Bola::EnMoviment()
{
	return Moventse;
}


// AfegirXoc()
//
// Afegeix la bola que passem de paràmetre a 
// la llista de boles amb les que xoca aquesta
// bola.
void Bola::AfegirXoc(Bola* b)
{
	if (b->getColor()==Color) XocoAmbMateixColor++;
	XocoAmb.push_back(b);
}

// EliminarXoc(Bola* b)
//
// Eliminar de la llista la bola que ens diuen
// Això normalment ho fem quan l'altra bola ha
// estat eliminada i és d'un altre color
void Bola::EliminarXoc(Bola* b)
{
	bool trobat=false;
	std::vector<Bola*>::iterator it = XocoAmb.begin();
	// Es tracta d'el
	
	while(it!=XocoAmb.end() && trobat==false)
	{
		if( (*it)==b )
		{
			XocoAmb.erase(it);
			trobat=true;
		}
		it++;
	}

	
}


// BolaEliminada()
//
// Marca la bola com eliminada
// 
void Bola::BolaEliminada()
{ Eliminada=true; 
#ifdef DEBUG
	printf("-- Eliminant la Bola %d:",ID);
#endif
}

// TreureXocs()
//
// Per eliminar els enllaços a la bola. Això només es crida quan s'ha
// d'eliminar completament aquesta bola...
//
// El que es fa és marcar les boles del mateix color que xoquen amb 
// aquesta com a Eliminades
// i eliminar els enllaços a les boles que xoquen amb aquesta que són 
// d'altes colors
void Bola::TreureXocs()
{
	// La bola actual està per matar
	BolaEliminada();
#ifdef DEBUG
	// Ara s'han de matar les altres, i treure els enllaços cap a ella.
	printf("...... xoca amb %d de les que %d són del mateix color %d\n", XocoAmb.size(), XocoAmbMateixColor, Color);
#endif
	for (int i=0; i<XocoAmb.size(); i++)
	{
		if (!XocoAmb[i]->EstaEliminada())
		{
			// Si és del mateix color, s'han d'eliminar els enllaços que tingui
			// perquè també desapareixerà i de pas la mato!
			if (XocoAmb[i]->getColor()==Color)
			{
				XocoAmb[i]->TreureXocs();
				// La marco per eliminar-la!
				// XocoAmb[i]->BolaEliminada();
				// delete XocoAmb[i];
				// XocoAmb[i]=NULL;
			}
			else
			{
				// Si no és del mateix color, només eliminem les referències a 
				// la bola actual perquè no despareix, només ho fa l'actual.
				XocoAmb[i]->EliminarXoc(this);
			}
		}
	}

}

// TestEliminacio()
//
// Comprovar si s'ha d'eliminar completament la bola
// --> Perquè està tocant a tres o més boles del mateix color
//
// Si s'ha d'eliminar crida la funció d'eliminar TreureXocs()
//
// El booleà que retornem ens informa de si hem eliminat boles 
// o no.
bool Bola::TestEliminacio()
{
	bool retorn=false;
	// Sé que l'he d'eliminar si xoca amb una groga que xoca amb una 
	// altra (o sigui amb dues del mateix color)
	for (int i=0; i<XocoAmb.size(); i++)
	{
		if (XocoAmb[i]!=NULL)
		{
			// Comprovem que la bola amb la que xoquem és del 
			// mateix color i això voldrà dir que n'hi ha una
			if (XocoAmb[i]->getColor()==Color)
			{
				// Comprovem que la bola amb la que hem xocat
				// xoca amb altres boles del mateix color
				// Si dóna 1: és que només xoca amb aquesta, i
				// si dóna més és que xoca amb d'altres...
				if (XocoAmb[i]->XocsDelColor()>1)
				{
					// Hem d'eliminar aquesta bola
					retorn=true;
					TreureXocs();
				}
			}
		}
	}	
	return retorn;
}

// MarcaPenjades
//
// Marca quines boles estan penjant de la bola actual 
// Això només es cridarà a partir de les boles que penjen del sostre
//
void Bola::MarcaPenjades()
{
	Penjant=true;

	for(int i=0; i<XocoAmb.size(); i++)
	{
		if (XocoAmb[i]->EstaEliminada()==false && XocoAmb[i]->EstaPenjant()==false)
		{
			XocoAmb[i]->MarcaPenjades();
		}
	}
}
