/*
    This file is part of CrabEmu.
 
    Copyright (C) 2008 Lawrence Sebald
 
    CrabEmu is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2
    as published by the Free Software Foundation.
 
    CrabEmu is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with CrabEmu; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
 
#include <dc/video.h>
#include <dc/biosfont.h>
#include <dc/maple.h>
#include <dc/maple/controller.h>
 
int pal_menu(void) {
    maple_device_t *cont1;
    cont_state_t *state;
 
    vid_set_mode(DM_640x480_PAL_IL, PM_RGB565);
 
    bfont_draw_str(vram_s + 640 * 200 + 64, 640, 1, "Press A to run at 60Hz");
    bfont_draw_str(vram_s + 640 * 240 + 64, 640, 1, "or B to run at 50Hz");

    cont1 = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
 
    for(;;) {
        if(cont1) {
            state = (cont_state_t *)maple_dev_status(cont1);

            if(state) {
                if(state->buttons & CONT_A) {
                    return 1;
                }
                else if(state->buttons & CONT_B) {
                    return 0;
                }
            }
        }
        else {
            cont1 = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
        }
    }
}