/*
         DCSI v0.4
        by D. Finck
     dgfinck@yahoo.com
 http://www.finck.net/dcsi/
 
 2013 report to KOS 2.X by Indiket
*/

#include <kos.h>	// KOS, top notch! ;)
#include "aica_fw.h"    // Player ARM code
KOS_INIT_FLAGS(INIT_DEFAULT); 

#include "sound.h"	// sound relates stuff
#include "rom_e.h"	// game rom data	
#include "rom_f.h"	// converted with
#include "rom_g.h"	// bin2c.exe
#include "rom_h.h"	// (a really handy program)
#include "rom2_d.h"	//
#include "rom2_e.h"	//
#include "rom2_f.h"	//
#include "rom2_g.h"	//
#include "rom2_h.h"	//
#include "sipic1.h"	// SI backdrop image data
#include "sipic2.h"	// SI Deluxe backdrop image
#include "vmu_gfx.h"	//
#include "cpu8080.h"	// header for POS8080Emu

void clearscr(int, int);
void sound_effect(int);
void init_sound(void);
void read_roms(void);
void putimage1(void);
void putimage2(void);
void convertimages(void);
void gui(void);

static int colors[32]={
  (0x0F<<11)|(0x1F<<5)|(0x1F), (0x0F<<11)|(0x22<<5)|(0x1F),
  (0x10<<11)|(0x24<<5)|(0x1E), (0x10<<11)|(0x26<<5)|(0x1E),
  (0x11<<11)|(0x28<<5)|(0x1D), (0x11<<11)|(0x2A<<5)|(0x1D),
  (0x12<<11)|(0x2C<<5)|(0x1C), (0x12<<11)|(0x2E<<5)|(0x1C),
  (0x13<<11)|(0x31<<5)|(0x1B), (0x13<<11)|(0x33<<5)|(0x1B),
  (0x14<<11)|(0x35<<5)|(0x1A), (0x14<<11)|(0x37<<5)|(0x1A),
  (0x15<<11)|(0x39<<5)|(0x19), (0x15<<11)|(0x3B<<5)|(0x19),
  (0x17<<11)|(0x3D<<5)|(0x18), (0x17<<11)|(0x3F<<5)|(0x18),
  (0x18<<11)|(0x3F<<5)|(0x17), (0x18<<11)|(0x3D<<5)|(0x17),
  (0x19<<11)|(0x3B<<5)|(0x15), (0x19<<11)|(0x39<<5)|(0x15),
  (0x1A<<11)|(0x37<<5)|(0x14), (0x1A<<11)|(0x35<<5)|(0x14),
  (0x1B<<11)|(0x33<<5)|(0x13), (0x1B<<11)|(0x31<<5)|(0x13),
  (0x1C<<11)|(0x2E<<5)|(0x12), (0x1C<<11)|(0x2C<<5)|(0x12),
  (0x1D<<11)|(0x2A<<5)|(0x11), (0x1D<<11)|(0x28<<5)|(0x11),
  (0x1E<<11)|(0x26<<5)|(0x10), (0x1E<<11)|(0x24<<5)|(0x10),
  (0x1F<<11)|(0x22<<5)|(0x0F), (0x1F<<11)|(0x1F<<5)|(0x0F),
};

word bg1[320*240];	//for background image
word bg2[320*240];	//for other background image
byte *mem;		//emulated memory space
byte dips=0;		//dipswitch
int game=0;		//0=SI 1=SI Deluxe
int running;
int squish=1;
byte shift1=0;
byte shift2=0;
byte shift3=0;
byte soundon3=0;
byte soundon5=0;
byte ufo=0;

/*Init in KOS style*/
int main(int argc, char **argv) {
  
  /*Init video with PM_RGB565 mode */
  vid_set_mode(DM_640x480, PM_RGB565);
	
  clearscr(640,480);
  
  //KOS has already a VMU draw function :)
  vmu_set_icon(vmu_si1_xpm);

  convertimages();			// convert 888 images to 565
  mem=malloc(0x10000);	 		// allocate 64k for 8080
  gui();
  
  //No need to exit to bios
  return(0);
}

void gui() {				// please forgive my ugly code,
  int egress=0;				// i taught myself C
  int refresh=1;
  while (egress==0) {
    
    //KOS: Obtain Maple Controller
	maple_device_t *mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
    if (!mcont) return;
    
	cont_state_t *cond = (cont_state_t *)maple_dev_status(mcont);
    if (!cond) return;
	
	//Now, read the Controller
    if ((cond->ltrig)&&(cond->rtrig)) 		// EXIT
      egress=1;
    if (cond->ltrig) {				// toggle squish-mode
      squish=1-squish;
      refresh=1;
    }
    if (cond->buttons & CONT_A) {		// PLAY A GAME
      clearscr(640,480);
	  
	  //KOS: use vid_set_mode and thd_sleep :)
      vid_set_mode(DM_320x240, PM_RGB565);
      thd_sleep(200);
      init_sound();
      running=1;
      read_roms();				//(also displays backdrop)
      reset_8080();
      while(running) {
	  
		vid_waitvbl();
	  
        int idle;
        run_8080(16667);			// = 2MHz / 60Hz / 2
        int_8080();				// not sure if this is 
        run_8080(16667);			// accurate or not
        nmi_8080();				//
        for(idle=800000;idle>0;idle--); {}	// really should be a timer
      }
      clearscr(320,240);
      vid_set_mode(DM_640x480, PM_RGB565);
      thd_sleep(200);
      refresh=1;
    }
    if ((cond->buttons & CONT_DPAD_LEFT) || (cond->buttons & CONT_DPAD_RIGHT) \
     || (cond->buttons & CONT_DPAD_UP) || (cond->buttons & CONT_DPAD_DOWN)) {
      game=1-game;
      refresh=1;
    }
    if ((cond->buttons & CONT_X)) {		// # of lives dipswitch
      int temp=dips&0x03;
      if (++temp == 4) temp=0;
      dips=(dips&0xFC)+temp;
      refresh=1;
    }
    if ((cond->buttons & CONT_Y)) {		// bonus dipswitch
      dips^=0x08;
      refresh=1;
    }
    if ((cond->buttons & CONT_B)) {		// coinage dipswitch
      dips^=0x80;
      refresh=1;
    }
    if (refresh) {				// update the 'GUI'
      refresh=0;
      clearscr(640,480);
	  //KOS: Add the 'opaque' argument!
      bfont_draw_str(vram_s+20*640+210, 640, 0, "DCSI v0.4");
      bfont_draw_str(vram_s+150*640+50, 640, 0,"A: PLAY!");
      bfont_draw_str(vram_s+210*640+50, 640, 0,"L+R = Exit");

      bfont_draw_str(vram_s+300*640+180, 640, 0,"In-game Controls");
      bfont_draw_str(vram_s+330*640+180, 640, 0," X = Insert Coin");
      bfont_draw_str(vram_s+360*640+180, 640, 0," L = 1 Player");
      bfont_draw_str(vram_s+390*640+180, 640, 0," R = 2 Player");
      bfont_draw_str(vram_s+420*640+180, 640, 0," A = Fire");

      if (game==0) {
        bfont_draw_str(vram_s+70*640+210, 640, 0,"Space Invaders");
        if ((dips&0x03) == 0)
          bfont_draw_str(vram_s+150*640+350, 640, 0,"X: 3 Lives");
        else if ((dips&0x03) == 1)
          bfont_draw_str(vram_s+150*640+350, 640, 0,"X: 4 Lives");
        else if ((dips&0x03) == 2)
          bfont_draw_str(vram_s+150*640+350, 640, 0,"X: 5 Lives");
        else 
          bfont_draw_str(vram_s+150*640+350, 640, 0,"X: 6 Lives");
        if (dips&0x08)
          bfont_draw_str(vram_s+180*640+350, 640, 0,"Y: Bonus @ 1000");
        else
          bfont_draw_str(vram_s+180*640+350, 640, 0,"Y: Bonus @ 1500");
      }
      else {
        bfont_draw_str(vram_s+70*640+150, 640, 0,"Space Invaders Deluxe");
        if (dips&0x01)
          bfont_draw_str(vram_s+150*640+350, 640, 0,"X: 4 Lives");
        else
          bfont_draw_str(vram_s+150*640+350, 640, 0,"X: 3 Lives");
        if (dips&0x08)
          bfont_draw_str(vram_s+180*640+350, 640, 0,"Y: Preset Mode: ON");
        else
          bfont_draw_str(vram_s+180*640+350, 640, 0,"Y: Preset Mode: OFF");
      }
      if (dips&0x80)
        bfont_draw_str(vram_s+210*640+350, 640, 0,"B: Coinage OFF");
      else
        bfont_draw_str(vram_s+210*640+350, 640, 0,"B: Coinage ON");
      if (squish)
        bfont_draw_str(vram_s+180*640+50, 640, 0,"L: Squish Screen ON");
      else
        bfont_draw_str(vram_s+180*640+50, 640, 0,"L: Squish Screen OFF");
    }
    thd_sleep(150);
  } 
}

void sound_effect(int idx) {
  snd_iface[SND_SMP_WHERE] = sfx_addr[idx];
  snd_iface[SND_SMP_SIZE] = sfx_size[idx]/2;
  snd_iface[SND_SMP_HZ] = 11025;
  snd_iface[SND_SMP] = 1;
}

//Use KOS AICA system!
//snd_iface definied in "sound.h", and s3mplay is in "aica_fw.h"
void init_sound(void) {

  spu_disable();
  spu_memload(sfx_addr[0],sample0,sizeof(sample0));
  spu_memload(sfx_addr[1],sample1,sizeof(sample1));
  spu_memload(sfx_addr[2],sample2,sizeof(sample2));
  spu_memload(sfx_addr[3],sample3,sizeof(sample3));
  spu_memload(sfx_addr[4],sample4,sizeof(sample4));
  spu_memload(sfx_addr[5],sample5,sizeof(sample5));
  spu_memload(sfx_addr[6],sample6,sizeof(sample6));
  spu_memload(sfx_addr[7],sample7,sizeof(sample7));
  spu_memload(sfx_addr[8],sample8,sizeof(sample8));
  snd_iface[SND_MONO] = 1;
  spu_memload(0, s3mplay, sizeof(s3mplay));

  spu_enable();
  while(*snd_iface != 3);
  while(*snd_iface == 3);
  
}

//eventually, these may be switched to read from the CD
//note i also display the background artwork here
void read_roms() {
  if (game) {
    memcpy(&mem[0x0000],&rom2_h,0x800);
    memcpy(&mem[0x0800],&rom2_g,0x800);
    memcpy(&mem[0x1000],&rom2_f,0x800);
    memcpy(&mem[0x1800],&rom2_e,0x800);
    memcpy(&mem[0x4000],&rom2_d,0x800);
    putimage2();
  }
  else {
    memcpy(&mem[0x0000],&rom_h,0x800);
    memcpy(&mem[0x0800],&rom_g,0x800);
    memcpy(&mem[0x1000],&rom_f,0x800);
    memcpy(&mem[0x1800],&rom_e,0x800);
    putimage1();
  }
}

void writemem(word addr,byte val) {
  if (addr<0x2000) return;
  mem[addr]=val;
  if(addr>=0x2400 && addr<0x4000) {
    if (game) {							//SI Deluxe video
      int xpos,ypos;
      int color;
      addr-=0x2400;
      xpos=addr>>5;
      ypos=240-((addr%32)<<3);
      if (squish) ypos=(ypos*19)/20;
      color=colors[(addr%32)];		// simulate the color overlay
      vram_s[45+xpos+(320*(ypos+0))] = ((val>>7)&1) ? color : bg2[45+xpos+(320*(ypos+0))];
      vram_s[45+xpos+(320*(ypos+1))] = ((val>>6)&1) ? color : bg2[45+xpos+(320*(ypos+1))];
      vram_s[45+xpos+(320*(ypos+2))] = ((val>>5)&1) ? color : bg2[45+xpos+(320*(ypos+2))];
      vram_s[45+xpos+(320*(ypos+3))] = ((val>>4)&1) ? color : bg2[45+xpos+(320*(ypos+3))];
      vram_s[45+xpos+(320*(ypos+4))] = ((val>>3)&1) ? color : bg2[45+xpos+(320*(ypos+4))];
      vram_s[45+xpos+(320*(ypos+5))] = ((val>>2)&1) ? color : bg2[45+xpos+(320*(ypos+5))];
      vram_s[45+xpos+(320*(ypos+6))] = ((val>>1)&1) ? color : bg2[45+xpos+(320*(ypos+6))];
      vram_s[45+xpos+(320*(ypos+7))] = ((val>>0)&1) ? color : bg2[45+xpos+(320*(ypos+7))];
    }
    else {							//SI video
      int xpos,ypos;
      int color=0xFFFF;						//white
      addr-=0x2400;
      xpos=addr>>5;
      ypos=240-((addr%32)<<3);
      if (squish) ypos=(ypos*19)/20;
      if ((addr%32)<8) color=(0x47E8);				//greenish
      else if ((addr%32)>25 && (addr%32)<28) color=(0xFA04);	//redish
      vram_s[45+xpos+(320*(ypos+0))] = ((val>>7)&1) ? color : bg1[45+xpos+(320*(ypos+0))];
      vram_s[45+xpos+(320*(ypos+1))] = ((val>>6)&1) ? color : bg1[45+xpos+(320*(ypos+1))];
      vram_s[45+xpos+(320*(ypos+2))] = ((val>>5)&1) ? color : bg1[45+xpos+(320*(ypos+2))];
      vram_s[45+xpos+(320*(ypos+3))] = ((val>>4)&1) ? color : bg1[45+xpos+(320*(ypos+3))];
      vram_s[45+xpos+(320*(ypos+4))] = ((val>>3)&1) ? color : bg1[45+xpos+(320*(ypos+4))];
      vram_s[45+xpos+(320*(ypos+5))] = ((val>>2)&1) ? color : bg1[45+xpos+(320*(ypos+5))];
      vram_s[45+xpos+(320*(ypos+6))] = ((val>>1)&1) ? color : bg1[45+xpos+(320*(ypos+6))];
      vram_s[45+xpos+(320*(ypos+7))] = ((val>>0)&1) ? color : bg1[45+xpos+(320*(ypos+7))];
    }
  }
}

inline byte readmem(word addr) {
  return mem[addr];
}

void outport(byte port,byte val) {
  if (port==2) {
    shift1=val&0x07;
  }
  else if (port==3) {
    if (val&01) {
      if (ufo++ == 100) {	// this ugly counter thingy
        sound_effect(0);	// seems to kind-of work for the
        ufo=0;			// repeating UFO sound...
      }				// (someone please improve it)
    }
    if (val&0x02 && ~soundon3&0x02) sound_effect(1);
    if (val&0x04 && ~soundon3&0x04) sound_effect(2);
    if (val&0x08 && ~soundon3&0x08) sound_effect(3);
    soundon3=val;
  }
  else if (port==4) {
    shift2=shift3;
    shift3=val;
  }    
  else if (port==5) {
    if (val&0x01 && ~soundon5&0x01) sound_effect(4);
    if (val&0x02 && ~soundon5&0x02) sound_effect(5);
    if (val&0x04 && ~soundon5&0x04) sound_effect(6);
    if (val&0x08 && ~soundon5&0x08) sound_effect(7);
    if (val&0x10 && ~soundon5&0x10) sound_effect(8);
    soundon5=val;
  }
}

byte inport(byte port) {
  if (port==0)  return (0x74);  //(makes SI2 work right; protection?)
  if (port==1) {
    byte tmp=0;
	//Read Maple
    maple_device_t *mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
    if (!mcont) return (0);
	cont_state_t *cond = (cont_state_t *)maple_dev_status(mcont);
    if (!cond) return (0);
	
    if((cond->buttons & CONT_X))          tmp|=(1<<0);	//coin
    if(cond->rtrig)                       tmp|=(1<<1);	//2pl
    if(cond->ltrig)                       tmp|=(1<<2);	//1pl
    if((cond->buttons & CONT_A))         tmp|=(1<<4);	//fire
    if((cond->buttons & CONT_DPAD_LEFT)) tmp|=(1<<5);	//left
    if((cond->buttons & CONT_DPAD_RIGHT))tmp|=(1<<6);	//right
    if((cond->buttons & CONT_B))         tmp|=(1<<6);	//right
    if((cond->buttons & CONT_START))     running=0;
    return tmp;
  }
  else if (port==2) {
    //Read Maple
    byte tmp=dips;
    maple_device_t *mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
    if (!mcont) return (0);
	cont_state_t *cond = (cont_state_t *)maple_dev_status(mcont);
    if (!cond) return (0);
	
    if((cond->buttons & CONT_Y))         tmp|=(1<<2);	//tilt
    if((cond->buttons & CONT_A))         tmp|=(1<<4);	//fire2
    if((cond->buttons & CONT_DPAD_LEFT)) tmp|=(1<<5);	//left2
    if((cond->buttons & CONT_DPAD_RIGHT))tmp|=(1<<6);	//right2
    if((cond->buttons & CONT_START))     running=0;
    return tmp;
  }
  else if (port==3)
    return(((((shift3<<8)+shift2)<<shift1)>>8)&0xFF);
  return(0);
}

// This function converts the image data, sipic[], which is a RAW
// 320x240x24 image in RGB format, to 16bit format in the array bg[].
// It also darkens it 'cause I decided I wanted the background a 
// little darker but I didn't want to re-do the image data :P
// It now also converts sipic2[] into bg2[], without darkening.
void convertimages() {
  int x,y;
  for(x=0;x<320;x++)
    for(y=0;y<240;y++) {
      int pos=y*320+x;
      bg1[pos]=((sipic1[pos*3]>>4)<<11)|((sipic1[pos*3+1]>>3)<<5)|(sipic1[pos*3+2]>>4);
      bg2[pos]=((sipic2[pos*3]>>3)<<11)|((sipic2[pos*3+1]>>2)<<5)|(sipic2[pos*3+2]>>3);
    }
}

void clearscr(int xres, int yres) {
  int x, y;
  for(x = 0; x < xres; x++)
    for(y = 0; y < yres; y++)
      vram_s[xres*y + x] = 0;
}

void putimage1() {
  int x,y;
  for(x=0;x<320;x++)
    for(y=0;y<240;y++) {
      vram_s[y*320+x] = bg1[y*320+x];
    }
}

void putimage2() {
  int x,y;
  for(x=0;x<320;x++)
    for(y=0;y<240;y++) {
      vram_s[y*320+x] = bg2[y*320+x];
    }
}
