#ifndef __TTT_H
#define __TTT_H

/* tictactoe.h

   Tic-Tac-Toe Header File
   DirtySanchez, 2/2002

*/

/* Define Player Positions */
#define PLAYER1		0
#define PLAYER2		1
#define PLAYER3		2
#define PLAYER4		3

/* Define Player Difficulty */
#define HUMAN		0
#define COMPUTEREASY	1
#define COMPUTERMED	2
#define COMPUTERHARD	3

/* Create Player Structure */
typedef struct player {
   int position;
   int difficulty;
} player;

/* Function Prototypes */

char check(void);
void get_controller_move(int playerpos, int *x, int *y);
void draw_cursor(int x, int y, int playerpos);
void erase_cursor(int x, int y);
void disp_startup(void);
void init_matrix(void);
void init_controllers(void);
void get_move(player playern);
void get_players(void);
void get_player_move(int playerpos);
void get_computer_move(player playern);
int pickCorner();
int pickRandom();
int makeWin(int position);
int makeBlock(int position);
int EmptySquareInLineWith(char player);
void disp_matrix(void);

#endif
