#include <kos.h>
#include "line.h"

#define PACK_RGB565(r,g,b) (((r>>3)<<11)|((g>>2)<<5)|((b>>3)<<0))

void line_fast (long x1, long y1, long x2, long y2, unsigned char r, unsigned char g, unsigned char b)
{
   long i, dx, dy, sdx, sdy, dxabs, dyabs, x, y, px, py;

   dx = x2 - x1;
   dy = y2 - y1;

   if (sgn(dx) != 1)
      dxabs = (dx * -1);
   else
      dxabs = (dx);

   if (sgn(dx) != 1)
      dyabs = (dy * -1);
   else
      dyabs = (dy);

   sdx = sgn(dx);
   sdy = sgn(dy);

   x = dyabs >> 1;
   y = dxabs >> 1;

   px = x1;
   py = y1;

   vram_s[py*640+px] = PACK_RGB565(r,g,b);
   
   if (dxabs >= dyabs)
   {
      for (i = 0; i < dxabs; i++)
      {
         y += dyabs;

         if (y >= dxabs)
         {
            y -= dxabs;
            py += sdy;
         }

         px += sdx;
         vram_s[py*640+px] = PACK_RGB565(r,g,b);
      }
   }
   else
   {

      for (i = 0; i < dyabs; i++)
      {
         x += dxabs;

         if (x >= dyabs)
         {
            x -= dyabs;
            px += sdx;
         }

         py += sdy;
         vram_s[py*640+px] = PACK_RGB565(r,g,b);
      }
   }
}

int sgn (long a)
{
   if (a > 0)
      return 1;
   else if (a < 0)
      return -1;
   else
      return 0;
}
