#include "util.h"

#ifdef DREAMCAST
#include <kos.h>
KOS_INIT_FLAGS(INIT_DEFAULT);
#include <SDL/SDL_dreamcast.h>
#endif

SDL_bool pantalla_completa=SDL_FALSE;

void colocar_en_formato_decimal(char * destino,int numero,int numero_decimal){
     memset(destino,'0',sizeof(char)*numero_decimal);
     
     char numero_str[numero_decimal];
     sprintf(numero_str,"%d",numero);
     int i,index_ini=numero_decimal-strlen(numero_str);
     for(i=index_ini;i<numero_decimal;i++)
         destino[i]=numero_str[i-index_ini];
}
    
SDL_Surface * iniciar_modo(void){
    static int full;
	#ifdef DREAMCAST
	int banderas= SDL_SWSURFACE;
	#else
    int banderas= SDL_ANYFORMAT|SDL_DOUBLEBUF|SDL_SWSURFACE;
    
    if(full)
       banderas|=SDL_FULLSCREEN;
    #endif
	
	//DREAMCAST: Game has been resized to 640x480
	SDL_Surface * pantalla = SDL_SetVideoMode(640, 480, 0,banderas);
    if(!pantalla){
        fprintf(stderr,"%s\n",SDL_GetError());
        exit(1);
    }

    full=!full;
    return pantalla;
}
void iniciar_sdl(){

    if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_JOYSTICK)<0){
           fprintf(stderr,"%s",SDL_GetError());
           exit(1);
       }
	   
    #ifdef DREAMCAST
    SDL_JoystickOpen (0);
	SDL_DC_MapKey(0,SDL_DC_START,SDLK_RETURN);
	SDL_DC_MapKey(0,SDL_DC_UP,SDLK_UP);
	SDL_DC_MapKey(0,SDL_DC_DOWN,SDLK_DOWN);
	SDL_DC_MapKey(0,SDL_DC_LEFT,SDLK_LEFT); 
	SDL_DC_MapKey(0,SDL_DC_RIGHT,SDLK_RIGHT);
	SDL_DC_MapKey(0,SDL_DC_A,SDLK_SPACE); //S:move piece down
	SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L:exits
	
	//Dreamcast delay...
	SDL_Event dcevent;
	SDL_PollEvent(&dcevent);
	#endif
	
    atexit(SDL_Quit);
}
void dibujar_objeto(SDL_Surface *src,Sint16 x,Sint16 y,SDL_Surface *dst){
    SDL_Rect dest={x,y,src->w,src->h};
    SDL_BlitSurface(src,NULL,dst,&dest);
}
inline SDL_bool punto_en_rect(Sint16 x,Sint16 y,SDL_Rect * rect_coli){
    return (x>rect_coli->x&&x<rect_coli->x+rect_coli->w&&y>rect_coli->y&&y<rect_coli->y+rect_coli->h);
}
inline SDL_bool punto_en_rect_coordenadas(Sint16 x_1,Sint16 y_1,Sint16 x_2,Sint16 y_2,Sint16 w_2,Sint16 h_2){
    return (x_1>x_2&&x_1<x_2+w_2&&y_1>y_2&&y_1<y_2+h_2);
    
}

SDL_Surface *cargar_imagen(char ruta[],SDL_bool optimizar)
{

	SDL_Surface * tmp;
	SDL_Surface * tmp2;

	tmp = IMG_Load (ruta);

	if (tmp == NULL)
	{
		printf ("No se puede cargar: '%s'\n", ruta);
		return NULL;
	}
	
	/* Optimiza la imagen */
	if(optimizar){
    	tmp2 = SDL_DisplayFormat (tmp);
   		SDL_FreeSurface (tmp);
   		tmp = tmp2;
    }


	printf ("+ cargando: %s\n", ruta);
    return tmp;
}
void imprimir_desde_grilla(SDL_Surface * src, int cuadro, SDL_Surface *dst,int x_dest,int y_dest, int fil, int col)
{
	SDL_Rect srcrect,dest_rect={x_dest,y_dest,0,0};

	srcrect.w = src->w / col;
	srcrect.h = src->h / fil;
	srcrect.x = (cuadro % col) * srcrect.w;
	srcrect.y = (cuadro / col) * srcrect.h;


	SDL_BlitSurface(src, &srcrect, dst, &dest_rect);
}

int fps_sincronizar (void)
{
	static int t;
	static int tl = 0;
	static int frecuencia = 1000 / 70;
	static int tmp;

	t = SDL_GetTicks ();

	if (t - tl >= frecuencia){
		tmp = (t - tl) / frecuencia;
		tl += tmp * frecuencia;
		return tmp;
	}
	else{
		SDL_Delay (frecuencia - (t - tl));
		tl += frecuencia;
		return 1;
	}

}


