#include "galeria.h"

Galeria * galeria_crear(Aplicacion * app){
     Galeria * nuevo;
     nuevo=(Galeria *)malloc(sizeof(Galeria));
     if(!nuevo){
         fprintf(stderr,"no hay memoria suficiente para almacenar estructura:Galeria\n");
         exit(1);
     }
     nuevo->app=app;
     return nuevo;
}

void galeria_cargar(Galeria * galeria){
    /*LOS FONDOS*/
    galeria->fondo_ventana_final=cargar_imagen("data/imagenes/ventanas/fondo_ventana_final.png",1);
    galeria->fondo_juego=cargar_imagen("data/imagenes/ventanas/fondo_juego.png",1);
    galeria->fondo_creditos=cargar_imagen("data/imagenes/ventanas/fondo_creditos.png",1);
    

    /*ESPECIFICO DEL ESTADO JUEGO*/
    galeria->grilla_bloques=cargar_imagen("data/imagenes/objetos/pelotas.png",0);
    galeria->tabla_bottom=cargar_imagen("data/imagenes/objetos/tabla.bmp",1);
    galeria->txt_puntaje_mayor=cargar_imagen("data/imagenes/textos/txt_mayor_puntaje.png",0);
    
    /*ESPECIFICO DEL ESTADO OPCIONES*/
    galeria->img_opcion_velocidad=cargar_imagen("data/imagenes/objetos/opcion_velocidad.png",0);
    
    
    /*TEXTOS PARA REALIZAR MENUS*/
    galeria->txt_reanudar=cargar_imagen("data/imagenes/textos/txt_reanudar.png",0);
    galeria->txt_reiniciar=cargar_imagen("data/imagenes/textos/txt_reiniciar.png",0);
    galeria->txt_guardar_salir=cargar_imagen("data/imagenes/textos/txt_guardar_salir.png",0);
    galeria->txt_menu=cargar_imagen("data/imagenes/textos/txt_menu.png",0);
    
    galeria->txt_cargar=cargar_imagen("data/imagenes/textos/txt_cargar.png",0);
    galeria->txt_nuevo=cargar_imagen("data/imagenes/textos/txt_nuevo.png",0);
    galeria->txt_opciones=cargar_imagen("data/imagenes/textos/txt_opciones.png",0);
    galeria->txt_creditos=cargar_imagen("data/imagenes/textos/txt_creditos.png",0);
    galeria->txt_salir=cargar_imagen("data/imagenes/textos/txt_salir.png",0);
    
    
    /*IMAGENES DE BOTONES PARA MENUS*/
    galeria->boton_aceptar=cargar_imagen("data/imagenes/botones/btn_aceptar.png",0);
    galeria->boton_cancelar=cargar_imagen("data/imagenes/botones/btn_cancelar.png",0);
    galeria->boton_menos=cargar_imagen("data/imagenes/botones/btn_menos.png",0);
    galeria->boton_mas=cargar_imagen("data/imagenes/botones/btn_mas.png",0);
    
    
    int i;
    char ruta[50];
    for(i=0;i<MAX_FUENTES;i++){
         sprintf(ruta,"data/imagenes/fuentes/fuente_%d.png",i+1);
         galeria->fuentes_imagen[i]=cargar_imagen(ruta,0);
    }
}

void galeria_terminar(Galeria * galeria){
    register int i;
    /*LOS FONDOS*/
    SDL_FreeSurface(galeria->fondo_ventana_final);
    SDL_FreeSurface(galeria->fondo_juego);
    SDL_FreeSurface(galeria->fondo_creditos);
    SDL_FreeSurface(galeria->img_opcion_velocidad);
    

    SDL_FreeSurface(galeria->txt_reanudar);
    SDL_FreeSurface(galeria->txt_reiniciar);
    SDL_FreeSurface(galeria->txt_guardar_salir);
    SDL_FreeSurface(galeria->txt_menu);
    SDL_FreeSurface(galeria->txt_cargar);
    SDL_FreeSurface(galeria->txt_nuevo);
    SDL_FreeSurface(galeria->txt_opciones);
    SDL_FreeSurface(galeria->txt_creditos);
    SDL_FreeSurface(galeria->txt_salir);
    
        
    SDL_FreeSurface(galeria->grilla_bloques);
    SDL_FreeSurface(galeria->txt_puntaje_mayor);
    
    for(i=0;i<MAX_FUENTES;i++)
        SDL_FreeSurface(galeria->fuentes_imagen[i]);

    SDL_FreeSurface(galeria->boton_aceptar);
    SDL_FreeSurface(galeria->tabla_bottom);
    SDL_FreeSurface(galeria->boton_cancelar);
    SDL_FreeSurface(galeria->boton_menos);
    SDL_FreeSurface(galeria->boton_mas);
    
    
}
