#include "configuracion.h"

#ifdef DREAMCAST
#include <kos.h>
#include "dreamcast_icon_config.h"
#endif

unsigned short vmu_icon_pal[];
/*POR AHORA SOLO lee la velocidad inicial*/

void configuracion_cargar(Configuracion * configuracion){
    FILE *f_config;
	
	//First try to load the config from the vmu
    #ifdef DREAMCAST
		char* data;
		file_t fd;
		int filesize;
		if ((fd = fs_open("/vmu/a1/blineacfg", O_RDONLY)) == -1)
		{
			printf("error opening VMU A1, no found blineacfg.\n");
		}
		else{
			filesize = fs_total(fd);
			data = (char*)malloc(filesize);

			//Go to the starting position of the data
			//Caution, vmu is composed by header (128) + 1 icon (512)
			//SEEK_SET (absolute position), SEEK_CUR (relative position)
			fs_seek(fd,128+512, SEEK_SET);
			fs_read(fd, data, filesize);

			// Save buffer into a RAM file
			if ((fd = fs_open("/ram/config.dat", O_WRONLY|O_CREAT|O_TRUNC)) == -1)
			{
				printf("Can't create RAM file from VMU.\n");
			}
			else{
				fs_write(fd, data, filesize);
				fs_close(fd);

				// Free unused memory
				free(data);
			}
		}
    #endif
	
	//Now, load the file
	#ifdef DREAMCAST
		f_config=fopen("/ram/config.dat","rb");
	#else
		f_config=fopen("configuraciones/config.dat","rb");
	#endif
    if(f_config==NULL){
        configuracion->vel_ini=1;
        return;
    }
    fread(configuracion,sizeof(struct Configuracion),1,f_config);
    fclose(f_config);
}    
void configuracion_guardar(Configuracion * configuracion){
    FILE *f_config;
	#ifdef DREAMCAST
		f_config=fopen("/ram/config.dat","wb");
	#else
		f_config=fopen("configuraciones/config.dat","wb");
	#endif
    fwrite(configuracion,sizeof(struct Configuracion),1,f_config);
    fclose(f_config);
	
	#ifdef DREAMCAST
		//Code to save to VMU!
		vmu_pkg_t pkg;
		uint8 *pkg_out;
		int pkg_size;
		file_t ft;

		//Temporal for reading the file
		file_t file;
		int data_size;
		char *datasave;

		// Open file and copy to buffer
		file = fs_open("/ram/config.dat", O_RDONLY);
		data_size = fs_total(file);
		datasave = (char *)malloc(data_size+1);
		fs_read(file, datasave, data_size);
		fs_close(file);

		//Make the package to the VMU.
		strcpy(pkg.desc_short, "blineacfg");
		strcpy(pkg.desc_long, "BalonLinea Config");
		strcpy(pkg.app_id, "blineacfg");
		pkg.icon_cnt = 1;
		memcpy((void *)&pkg.icon_pal[0],(void *)&vmu_iconcfg_pal,32);
		pkg.icon_data = (const uint8*)&vmu_iconcfg_img;
		pkg.icon_anim_speed = 0;
		pkg.eyecatch_type = VMUPKG_EC_NONE;
		pkg.data_len = data_size;
		pkg.data = (const uint8*) datasave;

		vmu_pkg_build(&pkg, &pkg_out, &pkg_size);

		fs_unlink("/vmu/a1/blineacfg");
		ft = fs_open("/vmu/a1/blineacfg", O_WRONLY);
		if (!ft) {
			printf("error writing\n");
			return;
		}
		fs_write(ft, pkg_out, pkg_size);
		fs_close(ft);

		// Free unused memory
		free(datasave);
	#endif
}
