#include "aplicacion.h"

Aplicacion * aplicacion_crear(){
     Aplicacion * nuevo;
     nuevo=(Aplicacion *)malloc(sizeof(Aplicacion));
     if(!nuevo){
         fprintf(stderr,"no hay memoria suficiente para almacenar estructura:Aplicacion\n");
         exit(1);
     }
     return nuevo;
}


int aplicacion_iniciar(Aplicacion * app){

    iniciar_sdl();
    
	//DREAMCAST: Prepare environment.
	#ifdef DREAMCAST
		fs_chdir("/cd");
	#else
		SDL_Surface * icono;

		icono = cargar_imagen("data/imagenes/objetos/icono.bmp",0);

		if(!icono) 
		 return 0;
		
		
		 // Establecemos el nombre de la ventana y el icono
		SDL_WM_SetIcon(icono, NULL); // Compatible con  Windows
		SDL_FreeSurface(icono);
	#endif
	
    app->pantalla=iniciar_modo();
 
    if(!app->pantalla)
     return 0;
 
    
    /*IMAGEN CARGANDO*/
    SDL_Surface *fondo_cargando;
    fondo_cargando=cargar_imagen("data/imagenes/ventanas/inicio_1.png",1);
    if(!fondo_cargando) 
     return 0;
    
    SDL_BlitSurface(fondo_cargando,NULL,app->pantalla,NULL);
    SDL_Flip(app->pantalla);
    SDL_FreeSurface(fondo_cargando);
	
	#ifndef DREAMCAST
    SDL_WM_SetCaption("BalonLineas 0.9.0",0);
	#endif
	
    SDL_ShowCursor(SDL_DISABLE);
    
    app->galeria=galeria_crear(app);
    if(!app->galeria)
        return 0;
        
    app->juego=juego_crear(app);
    if(!app->juego)
        return 0;
        
    app->menu=menu_crear(app);
    if(!app->menu)
        return 0;
        
    app->opciones=opciones_crear(app);
    if(!app->opciones)
        return 0;
    
    /*INICIAMOS TODOS LOS RECURSOS DEL JUEGO*/
    galeria_cargar(app->galeria);
    juego_iniciar(app->juego);
    menu_iniciar(app->menu);
    opciones_iniciar(app->opciones);
    
    FILE * fabrir=fopen("data/piezas.dat","rb");
    if(!fabrir)
    {
               fprintf(stderr,"No se encuentra archivo piezas.dat, no se puede continuar\ndescarge de nuevo la aplicacion en:\n\thttp://baulprogramas.blogspot.com/\n");
               return 0;
    }
    fread(app->plantillas,sizeof(int),25*4*7,fabrir);
    fclose(fabrir);
    
    
    app->modo_entrada=MODO_TECLADO;
    app->salir=0;
    app->interfaz=0;
    aplicacion_cambiar_interfaz(app,INTERFAZ_PRESENTACION);
    srand(time(0));
    return 1;
}


void aplicacion_cerrar(Aplicacion * app){
     app->salir=1;
}

void aplicacion_cambiar_interfaz(Aplicacion * app,Interfaz nueva){
     app->interfaz=nueva;
     switch(nueva){
        case INTERFAZ_MENU:
             menu_activar(app->menu);
             break;
        case INTERFAZ_OPCIONES:
             opciones_activar(app->opciones);
             break;
     }
}


void aplicacion_interfaz_menu(Aplicacion * app){
    menu_procesar_eventos(app->menu);                
    menu_ciclo_grafico(app->menu,app->pantalla);
    fps_sincronizar();
}

void aplicacion_interfaz_juego(Aplicacion * app){
    static int repeticiones,i;

    juego_procesar_eventos(app->juego);
    repeticiones=fps_sincronizar();
    for(i=0;i<repeticiones;i++){
        juego_ciclo_logico(app->juego);
    }
    
    juego_ciclo_grafico(app->juego,app->pantalla);
}

void aplicacion_interfaz_creditos(Aplicacion * app){
     static SDL_Event eventos;     

    while(SDL_PollEvent(&eventos)){
            if(eventos.type==SDL_QUIT){
                aplicacion_cerrar(app);
            }
            else if(eventos.type==SDL_KEYUP||eventos.type==SDL_MOUSEBUTTONUP){
                aplicacion_cambiar_interfaz(app,INTERFAZ_MENU);
            }
    }
    SDL_BlitSurface(app->galeria->fondo_creditos,NULL,app->pantalla,NULL);
    fps_sincronizar();
}

void aplicacion_interfaz_opciones(Aplicacion * app){
    opciones_procesar_eventos(app->opciones);                
    opciones_ciclo_grafico(app->opciones,app->pantalla);
    fps_sincronizar();
}
void aplicacion_interfaz_presentacion(Aplicacion * app){
     static SDL_Event eventos;     
     static int delay_empezar;
     
    if(++delay_empezar>20){
        aplicacion_cambiar_interfaz(app,INTERFAZ_MENU);
    }
    else{
        //si aun no se ha acabado el mostrar el loading
        while(SDL_PollEvent(&eventos))
            if(eventos.type==SDL_QUIT){
                aplicacion_cerrar(app);
            }
            
    }
    SDL_Delay(20);
}
void aplicacion_loop(Aplicacion * app){
    //game loop
    while(!app->salir){
            switch(app->interfaz){
                case INTERFAZ_MENU:
                     aplicacion_interfaz_menu(app);
                     break;
                case INTERFAZ_JUEGO:
                     aplicacion_interfaz_juego(app);
                     break;
                case INTERFAZ_CREDITOS:
                     aplicacion_interfaz_creditos(app);
                     break;
                case INTERFAZ_OPCIONES:
                     aplicacion_interfaz_opciones(app);
                     break;
                case INTERFAZ_PRESENTACION:
                     aplicacion_interfaz_presentacion(app);
                     break;

            }

        SDL_Flip(app->pantalla);
        				
    }//fin while loop

}

void aplicacion_terminar(Aplicacion * app){
	//DREAMCAST: It crash system so... don't do it
    #ifndef DREAMCAST  
		galeria_terminar(app->galeria);
		juego_terminar(app->juego);
		opciones_terminar(app->opciones);
		menu_terminar(app->menu);
		free(app->galeria);
		free(app->juego);
		free(app->opciones);
		free(app->menu);
	#endif
}
