#ifndef ESTRUCTURAS_H
#define ESTRUCTURAS_H
#include <SDL/SDL.h>
#include "constantes.h"


/*POR AHORA SOLO lee la velocidad inicial*/
typedef struct Configuracion{
    int vel_ini;
}Configuracion;


typedef struct Ball{
     float vel_y;
     int activo;
     int x,y;
     int choco_con_piso;
     int id;
}Ball;


typedef struct Opciones{
    struct Aplicacion * app;

    struct Boton * botones[4];

    Configuracion config;
    Uint8 selected;
}Opciones;

typedef struct Juego{
    struct Aplicacion * app;
    
    struct Bloque *bloque_actual,* bloque_siguiente;
    struct Configuracion config;

    int puntaje,lineas_completadas,velocidad;
    int mayor_puntaje;
    Estados_juego estado;
    Cint vector_screen[H_JUEGO/W_H_BLOQUE][W_JUEGO/W_H_BLOQUE];
    Uint8 selected;//variable usada por ambos
    Ball pelotas[W_JUEGO/20*4];
}Juego;

typedef struct Galeria{
       struct Aplicacion * app;
        
        /*FONDOS DE LOS ESTADOS*/
        SDL_Surface *fondo_juego,*fondo_ventana_final,*fondo_creditos;
        
        /*ESPECIFICO DEL ESTADO JUEGO*/
        SDL_Surface *grilla_bloques,*txt_puntaje_mayor;

        /*ESPECIFICO DEL ESTADO OPCIONES*/
        SDL_Surface *img_opcion_velocidad;
        
        /*TEXTOS PARA REALIZAR MENUS*/

        //MODIFICAR LAS IMAGENES Y PONERLAS EN UNA SOLA GRILLA
        SDL_Surface *txt_reanudar,\
                    *txt_reiniciar,\
                    *txt_guardar_salir,\
                    *txt_menu,\
                    *txt_cargar,\
                    *txt_nuevo,\
                    *txt_opciones,\
                    *txt_creditos,\
                    *txt_salir,
                    *fuentes_imagen[MAX_FUENTES],
                    *tabla_bottom;
        
    
        
        /*BOTONES DISPONIBLES A LOS ESTADOS*/
        SDL_Surface *boton_aceptar,*boton_cancelar,*boton_menos,*boton_mas;
}Galeria;
typedef struct Menu{
    struct Aplicacion * app;
    
    struct Boton * botones[5];
    Uint8 selected;
}Menu;
typedef struct Aplicacion{
        
        /*ESTADOS DEL JUEGO*/    
        struct Galeria * galeria;
        struct Juego * juego;
        struct Menu * menu;
        struct Opciones * opciones;
        
        Modo_entrada modo_entrada;//solo puede almacenar si es por el teclado o por el mouse
        SDL_Surface *pantalla;
        int salir;
        int plantillas[7][4][5*5];
        Interfaz interfaz;//,estado_siguiente=SALIR;
}Aplicacion;
typedef struct Bloque{
        struct Aplicacion * app;
        
        Sint16 x,y;
        TipoBloque tipo;
        Uint16 rotacion;
        float vel_y;
}Bloque;

typedef struct Boton{
        SDL_Surface * img;
        SDL_Rect rect;
        Estados_boton estado;
        int visible,id;
        int num_estados;
}Boton;

#endif
