#include "boton.h"


Boton * boton_crear(){
     Boton * nuevo;
     nuevo=(Boton *)malloc(sizeof(Boton));
     if(!nuevo){
         fprintf(stderr,"no hay memoria suficiente para almacenar estructura:Boton\n");
         exit(1);
     }
     return nuevo;
}

void boton_iniciar(Boton * btn){
     btn->visible=0;
     btn->img=NULL;
     btn->rect.x=0;
     btn->rect.y=0;
     btn->rect.w=0;
     btn->rect.h=0;
     btn->estado=-1;
}

int boton_en_punto(Boton * btn,int x,int y){
    if(btn->visible)
       return punto_en_rect(x,y,&btn->rect);
    return 0;        
       
}
void boton_activar(Boton * btn,int id,SDL_Surface * imagen,int x,int y,int num_estados){
      btn->img=imagen;
      btn->id=id;
      btn->rect.x=x;
      btn->rect.y=y;
      btn->rect.w=btn->img->w;
      btn->rect.h=btn->img->h/num_estados;
      btn->num_estados=num_estados;
      btn->visible=1;
      btn->estado=BOTON_NORMAL;//boton en estado de reposo
}

void boton_imprimir(Boton * btn,SDL_Surface * superficie){
     imprimir_desde_grilla(btn->img,btn->estado,superficie,btn->rect.x,btn->rect.y,btn->num_estados,1,0);
}
