#include "opciones.h"


Opciones * opciones_crear(Aplicacion * app){
     Opciones * nuevo;
     nuevo=(Opciones *)malloc(sizeof(Opciones));
     if(!nuevo){
         fprintf(stderr,"no hay memoria suficiente para almacenar estructura:Opciones\n");
         exit(1);
     }
     nuevo->app=app;
     return nuevo;
}

void opciones_iniciar(Opciones *opc){
    //cargamos los recursos de este estado

	#ifdef DREAMCAST
	//640x480
	opc->botones[MENU_OPCION_MAS]=boton_crear();
    boton_activar(opc->botones[MENU_OPCION_MAS],MENU_OPCION_MAS,opc->app->galeria->boton_mas,408,152,3);
    
    opc->botones[MENU_OPCION_MENOS]=boton_crear();
    boton_activar(opc->botones[MENU_OPCION_MENOS],MENU_OPCION_MENOS,opc->app->galeria->boton_menos,410,204,3);
    
    opc->botones[MENU_OPCION_ACEPTAR]=boton_crear();
    boton_activar(opc->botones[MENU_OPCION_ACEPTAR],MENU_OPCION_ACEPTAR,opc->app->galeria->boton_aceptar,192,436,3);
    
    opc->botones[MENU_OPCION_CANCELAR]=boton_crear();
    boton_activar(opc->botones[MENU_OPCION_CANCELAR],MENU_OPCION_CANCELAR,opc->app->galeria->boton_cancelar,332,436,3);
	
	#else
    opc->botones[MENU_OPCION_MAS]=boton_crear();
    boton_activar(opc->botones[MENU_OPCION_MAS],MENU_OPCION_MAS,opc->app->galeria->boton_mas,510,190,3);
    
    opc->botones[MENU_OPCION_MENOS]=boton_crear();
    boton_activar(opc->botones[MENU_OPCION_MENOS],MENU_OPCION_MENOS,opc->app->galeria->boton_menos,512,256,3);
    
    opc->botones[MENU_OPCION_ACEPTAR]=boton_crear();
    boton_activar(opc->botones[MENU_OPCION_ACEPTAR],MENU_OPCION_ACEPTAR,opc->app->galeria->boton_aceptar,240,545,3);
    
    opc->botones[MENU_OPCION_CANCELAR]=boton_crear();
    boton_activar(opc->botones[MENU_OPCION_CANCELAR],MENU_OPCION_CANCELAR,opc->app->galeria->boton_cancelar,416,545,3);
	#endif
}

void opciones_activar(Opciones * opc){

    SDL_ShowCursor(opc->app->modo_entrada==MODO_CURSOR);
    SDL_WarpMouse(W_SCREEN/2, H_SCREEN/2);
    opc->selected=0;
    opc->botones[0]->estado=BOTON_RESALTADO;
    configuracion_cargar(&opc->config);
}

void opciones_accionar_selected(Opciones * opc){
	switch(opc->selected){
		case MENU_OPCION_MAS:
             opc->config.vel_ini=(opc->config.vel_ini==10)?10:opc->config.vel_ini + 1;
			break;
		case MENU_OPCION_MENOS:
             opc->config.vel_ini=(opc->config.vel_ini==0)?0:opc->config.vel_ini - 1;
			break;
		case MENU_OPCION_ACEPTAR:
           configuracion_guardar(&opc->config); 
           aplicacion_cambiar_interfaz(opc->app,INTERFAZ_MENU);
			break;
		case MENU_OPCION_CANCELAR:
           aplicacion_cambiar_interfaz(opc->app,INTERFAZ_MENU);
			break;
		}
}
void opciones_procesar_eventos(Opciones * opc){
    static SDL_Event eventos;
    static int i;
    
    while (SDL_PollEvent(&eventos)){

		  // evento de cierre del programa
		    if(eventos.type==SDL_QUIT){
                aplicacion_cerrar(opc->app);
                return;
            }
            else if(eventos.type==SDL_KEYDOWN)
			{
                if(eventos.key.keysym.sym==SDLK_RETURN && eventos.key.keysym.mod & SDLK_LALT)
                {
    				opc->app->pantalla=iniciar_modo();
                }else if(eventos.key.keysym.sym==SDLK_ESCAPE){
                      aplicacion_cambiar_interfaz(opc->app,INTERFAZ_MENU);
                      return;
                }
             }
			switch(opc->app->modo_entrada){
					case MODO_TECLADO:
							if(eventos.type==SDL_KEYDOWN)
                            {
									switch(eventos.key.keysym.sym)
                                    {
										case SDLK_DOWN:
												if(opc->selected<MENU_OPCION_CANCELAR)
                                                {
													opc->botones[opc->selected]->estado=BOTON_NORMAL;
													opc->botones[++opc->selected]->estado=BOTON_RESALTADO;
												}
												break;
										case SDLK_UP:
												if(opc->selected>0)
                                                {
													opc->botones[opc->selected]->estado=BOTON_NORMAL;
													opc->botones[--opc->selected]->estado=BOTON_RESALTADO;
												}
											break;
										case SDLK_RETURN:
									        opc->botones[opc->selected]->estado=BOTON_PRESIONADO;
											break;
									}
							}else if(eventos.type==SDL_KEYUP&&eventos.key.keysym.sym==SDLK_RETURN){
								opc->botones[opc->selected]->estado=BOTON_RESALTADO;
								opciones_accionar_selected(opc);
                            }
							#ifndef DREAMCAST
							//DREAMCAST: No mouse is used!
							else if(eventos.type == SDL_MOUSEBUTTONDOWN){
                                    SDL_ShowCursor(SDL_ENABLE);
									opc->botones[opc->selected]->estado=BOTON_NORMAL;
									opc->app->modo_entrada=MODO_CURSOR;
							}
							#endif
    					break;
				
			case MODO_CURSOR:
					if(eventos.type == SDL_MOUSEMOTION)
                    {
                           for(i=0;i<4;i++)
                           {
    							if(boton_en_punto(opc->botones[i],eventos.motion.x,eventos.motion.y))
                                {
    								opc->selected=i;
    								opc->botones[i]->estado=BOTON_RESALTADO;
    							}
    							else
    								opc->botones[i]->estado=BOTON_NORMAL;
                            }
					}
					else if((eventos.type == SDL_MOUSEBUTTONUP||eventos.type == SDL_MOUSEBUTTONDOWN)&&eventos.button.button==SDL_BUTTON_LEFT) 
                    {
                           for(i=0;i<4;i++)
                           {
    							if(boton_en_punto(opc->botones[i],eventos.motion.x,eventos.motion.y))
                                {
    								if(eventos.button.type == SDL_MOUSEBUTTONDOWN)
    								     opc->botones[i]->estado=BOTON_PRESIONADO;
    								else
                                          opciones_accionar_selected(opc);
    								
    							}
    							else
    								opc->botones[i]->estado=BOTON_NORMAL;
                            }
                    }
   
					else if(eventos.button.type == SDL_MOUSEBUTTONDOWN)
                    {
                        SDL_ShowCursor(SDL_DISABLE);
						opc->botones[opc->selected]->estado=BOTON_RESALTADO;
						opc->app->modo_entrada=MODO_TECLADO;
                    }
						
					break;
				default:
                    fprintf(stderr,"error grave en modo de entrada.\n");
				}//fin switch
                
    }//fin while
}


void opciones_ciclo_grafico(Opciones * opc,SDL_Surface * screen){
    static int i;
     
    SDL_BlitSurface(opc->app->galeria->fondo_ventana_final,NULL,screen,NULL);
	#ifdef DREAMCAST
		//640x480
		dibujar_objeto(opc->app->galeria->img_opcion_velocidad,125,173,screen);
	#else
		dibujar_objeto(opc->app->galeria->img_opcion_velocidad,237,217,screen);
	#endif

    for(i=0;i<4;i++)
       boton_imprimir(opc->botones[i],screen);
    
	#ifdef DREAMCAST
		//640x480
		mostrar_msg(screen,opc->app->galeria->fuentes_imagen[0],409,170,"%d",opc->config.vel_ini);
	#else
		mostrar_msg(screen,opc->app->galeria->fuentes_imagen[0],509,213,"%d",opc->config.vel_ini);
	#endif
}

void opciones_terminar(Opciones * opc)
{
     int i;
     for(i=0;i<5;i++)free(opc->botones[i]);
}
