#include "menu.h"

Menu * menu_crear(Aplicacion * app){
     Menu * nuevo;
     nuevo=(Menu *)malloc(sizeof(Menu));
     if(!nuevo){
         fprintf(stderr,"no hay memoria suficiente para almacenar estructura:Menu\n");
         exit(1);
     }
     nuevo->app=app;
     return nuevo;
}
void menu_activar(Menu * menu){
     menu->selected=0;
     menu->botones[MENU_OPCION_CARGAR]->estado=BOTON_RESALTADO;
}

void menu_iniciar(Menu * menu)
{
#ifdef DREAMCAST
	//640x480: images moved
	menu->botones[MENU_OPCION_CARGAR]=boton_crear();
    boton_activar(menu->botones[MENU_OPCION_CARGAR],MENU_OPCION_CARGAR,menu->app->galeria->txt_cargar,229,169,2);    
    
    menu->botones[MENU_OPCION_NUEVO]=boton_crear();
    boton_activar(menu->botones[MENU_OPCION_NUEVO],MENU_OPCION_NUEVO,menu->app->galeria->txt_nuevo,244,230,2);

    menu->botones[MENU_OPCION_OPCIONES]=boton_crear();
    boton_activar(menu->botones[MENU_OPCION_OPCIONES],MENU_OPCION_OPCIONES,menu->app->galeria->txt_opciones,229,287,2);

    menu->botones[MENU_OPCION_CREDITOS]=boton_crear();
    boton_activar(menu->botones[MENU_OPCION_CREDITOS],MENU_OPCION_CREDITOS,menu->app->galeria->txt_creditos,224,344,2);

    menu->botones[MENU_OPCION_SALIR]=boton_crear();
    boton_activar(menu->botones[MENU_OPCION_SALIR],MENU_OPCION_SALIR,menu->app->galeria->txt_salir,251,394,2);
	
#else

    menu->botones[MENU_OPCION_CARGAR]=boton_crear();
    boton_activar(menu->botones[MENU_OPCION_CARGAR],MENU_OPCION_CARGAR,menu->app->galeria->txt_cargar,287,199,2);    
    
    menu->botones[MENU_OPCION_NUEVO]=boton_crear();
    boton_activar(menu->botones[MENU_OPCION_NUEVO],MENU_OPCION_NUEVO,menu->app->galeria->txt_nuevo,305,260,2);

    menu->botones[MENU_OPCION_OPCIONES]=boton_crear();
    boton_activar(menu->botones[MENU_OPCION_OPCIONES],MENU_OPCION_OPCIONES,menu->app->galeria->txt_opciones,287,317,2);

    menu->botones[MENU_OPCION_CREDITOS]=boton_crear();
    boton_activar(menu->botones[MENU_OPCION_CREDITOS],MENU_OPCION_CREDITOS,menu->app->galeria->txt_creditos,280,374,2);

    menu->botones[MENU_OPCION_SALIR]=boton_crear();
    boton_activar(menu->botones[MENU_OPCION_SALIR],MENU_OPCION_SALIR,menu->app->galeria->txt_salir,314,424,2);
#endif

}
void menu_limpiar(Menu * menu){
     menu->botones[menu->selected]->estado=BOTON_NORMAL;
}

void menu_accionar_selected(Menu * menu,int selected){
	switch(selected)
	{
		case  MENU_OPCION_CARGAR:case  MENU_OPCION_NUEVO:
            menu_limpiar(menu);
			juego_activar(menu->app->juego,menu->selected==MENU_OPCION_CARGAR);
			aplicacion_cambiar_interfaz(menu->app,INTERFAZ_JUEGO);
			break;
		case  MENU_OPCION_CREDITOS:
            menu_limpiar(menu);
			aplicacion_cambiar_interfaz(menu->app,INTERFAZ_CREDITOS);
			break;
		case  MENU_OPCION_OPCIONES:
            menu_limpiar(menu);
			aplicacion_cambiar_interfaz(menu->app,INTERFAZ_OPCIONES);
			break;
		case MENU_OPCION_SALIR:
			aplicacion_cerrar(menu->app);
			break;
		default:
          printf("Advertencia:Select de menu no reconocido\n");
	}
}
void menu_procesar_eventos(Menu * menu)
{
    static SDL_Event eventos;
    
    	while (SDL_PollEvent(&eventos))
		{
				
		  // evento de cierre del programa
		    if(eventos.type==SDL_QUIT){
                aplicacion_cerrar(menu->app);
                return;
            }
            else if(eventos.type==SDL_KEYDOWN)
			{
                if(eventos.key.keysym.sym==SDLK_RETURN && eventos.key.keysym.mod & SDLK_LALT)
                {
    				menu->app->pantalla=iniciar_modo();
                }else if(eventos.key.keysym.sym==SDLK_ESCAPE){
                      aplicacion_cambiar_interfaz(menu->app,INTERFAZ_MENU);
                      return;
                }
             }
                
			switch(menu->app->modo_entrada){
				
				case MODO_TECLADO:
						if(eventos.type==SDL_KEYDOWN)
                        {
							switch(eventos.key.keysym.sym)
							{
								case SDLK_UP:
                                     if(menu->selected!=0)
                                     {
                                         menu->botones[menu->selected]->estado=BOTON_NORMAL;
                                         menu->botones[--menu->selected]->estado=BOTON_RESALTADO;
                                     }
									break;
								case SDLK_DOWN:
                                     if(menu->selected<MENU_OPCION_SALIR)
                                     {
                                         menu->botones[menu->selected]->estado=BOTON_NORMAL;
                                         menu->botones[++menu->selected]->estado=BOTON_RESALTADO;
                                     }

									break;
							}//fin switch(id de la tecla)
						}else if(eventos.type==SDL_KEYUP&&eventos.key.keysym.sym==SDLK_RETURN){
								menu_accionar_selected(menu,menu->selected);
                            }
						#ifndef DREAMCAST
						//DREAMCAST: No mouse is used!
						else if(eventos.type == SDL_MOUSEBUTTONDOWN&&eventos.button.button==SDL_BUTTON_LEFT){
                            menu_cambiar_modo_entrada(menu,MODO_CURSOR);
						}
						#endif
					break;//fin case MODO_TECLADO
				case MODO_CURSOR:
					if(eventos.type == SDL_MOUSEMOTION)
                    {
                         static int i;
                         for(i=0;i<5;i++)
                         {
                             if(boton_en_punto(menu->botones[i],eventos.motion.x,eventos.motion.y))
                             {
                                    menu->botones[i]->estado=BOTON_RESALTADO;
                                    menu->selected=i;
                                    return;
                             }else
                                    menu->botones[i]->estado=BOTON_NORMAL;
                         }
						
					}
					else if(eventos.type == SDL_MOUSEBUTTONUP&&eventos.button.button==SDL_BUTTON_LEFT) 
                    {
                         static int i;
                         for(i=0;i<5;i++)
                         {
                             if(boton_en_punto(menu->botones[i],eventos.motion.x,eventos.motion.y))
                                    menu_accionar_selected(menu,i);
                             
                         }
					}
					else if(eventos.type==SDL_KEYDOWN)
                    {
                         menu_cambiar_modo_entrada(menu,MODO_TECLADO);
					}
				break;
			}//fin switch de modo entrada

	}//fin bucle
}//fin funcion

void menu_cambiar_modo_entrada(Menu * menu,Modo_entrada nuevo){
	menu->app->modo_entrada=nuevo;
	menu->selected=0;
	SDL_ShowCursor(nuevo==MODO_CURSOR);
	SDL_WarpMouse(W_SCREEN/2,H_SCREEN/2);
}

void menu_ciclo_grafico(Menu * menu,SDL_Surface * screen){
    SDL_BlitSurface(menu->app->galeria->fondo_ventana_final,NULL,screen,NULL);
     static int i;
     for(i=0;i<5;i++)
     boton_imprimir(menu->botones[i],screen);
}

void menu_terminar(Menu * menu){
     int i;
     for(i=0;i<5;i++)free(menu->botones[i]);
}
