#include "juego.h"

#ifdef DREAMCAST
#include <kos.h>
#include "dreamcast_icon_game.h"
#endif

Juego * juego_crear(Aplicacion * app){
     Juego * nuevo;
     nuevo=(Juego *)malloc(sizeof(Juego));
     if(!nuevo){
         fprintf(stderr,"no hay memoria suficiente para almacenar estructura:Juego\n");
         exit(1);
     }
     nuevo->app=app;
     return nuevo;
}

int juego_iniciar(Juego * juego){
    juego->bloque_actual=bloque_crear(juego->app);
    juego->bloque_siguiente=bloque_crear(juego->app);
    
    int i;
    for(i=0;i<W_JUEGO/20*4;i++)
       juego->pelotas[i].activo=0;

    return 1;
}

void juego_activar(Juego *juego,int cargar_de_file)
{
    SDL_ShowCursor(0);
    juego->selected=0;
    juego->estado=JUEGO_RUN;
    juego_cargar_puntaje_alto(juego);

    if(cargar_de_file){
        juego_cargar(juego);
    }else
        juego_reiniciar(juego);
        
}
void juego_cargar(Juego *juego){
    register int i;
    FILE *fcargar;
	
	//First try to load the game from the vmu
    #ifdef DREAMCAST
		char* data;
		file_t fd;
		int filesize;
		if ((fd = fs_open("/vmu/a1/blineasav", O_RDONLY)) == -1)
		{
			printf("error opening VMU A1, no found blineasav.\n");
		}
		else{
			filesize = fs_total(fd);
			data = (char*)malloc(filesize);

			//Go to the starting position of the data
			//Caution, vmu is composed by header (128) + 1 icon (512)
			//SEEK_SET (absolute position), SEEK_CUR (relative position)
			fs_seek(fd,128+512, SEEK_SET);
			fs_read(fd, data, filesize);

			// Save buffer into a RAM file
			if ((fd = fs_open("/ram/saved.dat", O_WRONLY|O_CREAT|O_TRUNC)) == -1)
			{
				printf("Can't create RAM file from VMU.\n");
			}
			else{
				fs_write(fd, data, filesize);
				fs_close(fd);

				// Free unused memory
				free(data);
			}
		}
    #endif
	
	#ifdef DREAMCAST
		fcargar=fopen("/ram/saved.dat","rb");
	#else
		fcargar=fopen("configuraciones/saved.dat","rb");
	#endif
    if(fcargar==NULL){//si no se puede cargar la partida
        juego_reiniciar(juego);//se reinicia
        return;
    }
    
    //cargamos linea a linea el vector de la screen
    for(i=0;i<H_JUEGO/W_H_BLOQUE;i++)
        fread(juego->vector_screen[i], sizeof(unsigned char), W_JUEGO/W_H_BLOQUE, fcargar);

    //cargamos los bloques
    free(juego->bloque_actual);
    free(juego->bloque_siguiente);
    fread(juego->bloque_actual, sizeof(Bloque),1, fcargar);
    fread(juego->bloque_siguiente, sizeof(Bloque),1, fcargar);    
    
    //cargamos los datos
    fread(&(juego->puntaje), sizeof(int),1, fcargar);
    fread(&(juego->lineas_completadas), sizeof(int),1, fcargar);    
    fread(&(juego->velocidad), sizeof(int),1, fcargar);
    fclose(fcargar);//cerramos el archivo
}
void juego_guardar(Juego *juego){
    register int i;
    FILE *fguardar;
	
	#ifdef DREAMCAST
		fguardar=fopen("/ram/saved.dat","wb");
	#else
		fguardar=fopen("configuraciones/saved.dat","wb");
	#endif
	    
	if (fguardar!=NULL)
    {
		//guardamos linea a linea
		for(i=0;i<H_JUEGO/W_H_BLOQUE;i++)
			fwrite(juego->vector_screen[i], sizeof(unsigned char), W_JUEGO/W_H_BLOQUE, fguardar);

		//guardamos los bloques
		fwrite(juego->bloque_actual, sizeof(Bloque),1, fguardar);
		fwrite(juego->bloque_siguiente, sizeof(Bloque),1, fguardar);    
		
		//guardamos los datos
		fwrite(&(juego->puntaje), sizeof(int),1, fguardar);
		fwrite(&(juego->lineas_completadas), sizeof(int),1, fguardar);    
		fwrite(&(juego->velocidad), sizeof(int),1, fguardar);
		fclose(fguardar);
		
		#ifdef DREAMCAST
			//Code to save to VMU!
			vmu_pkg_t pkg;
			uint8 *pkg_out;
			int pkg_size;
			file_t ft;

			//Temporal for reading the file
			file_t filedc;
			int data_size;
			char *datasave;

			// Open file and copy to buffer
			filedc = fs_open("/ram/saved.dat", O_RDONLY);
			data_size = fs_total(filedc);
			datasave = (char *)malloc(data_size+1);
			fs_read(filedc, datasave, data_size);
			fs_close(filedc);

			//Make the package to the VMU.
			strcpy(pkg.desc_short, "blineasav");
			strcpy(pkg.desc_long, "BalonLinea Save");
			strcpy(pkg.app_id, "blineasav");
			pkg.icon_cnt = 1;
			memcpy((void *)&pkg.icon_pal[0],(void *)&vmu_icongame_pal,32);
			pkg.icon_data = (const uint8*)&vmu_icongame_img;
			pkg.icon_anim_speed = 0;
			pkg.eyecatch_type = VMUPKG_EC_NONE;
			pkg.data_len = data_size;
			pkg.data = (const uint8*) datasave;

			vmu_pkg_build(&pkg, &pkg_out, &pkg_size);

			fs_unlink("/vmu/a1/blineasav");
			ft = fs_open("/vmu/a1/blineasav", O_WRONLY);
			if (!ft) {
				printf("error writing\n");
				return;
			}
			fs_write(ft, pkg_out, pkg_size);
			fs_close(ft);

			// Free unused memory
			free(datasave);
		#endif
    }
}

void juego_reiniciar(Juego *juego){
    register int i,j;
    
    //iniciamos a cero el vector de la screen
    for(i=0;i<H_JUEGO/W_H_BLOQUE;i++)
        for(j=0;j<W_JUEGO/W_H_BLOQUE;j++)
            juego->vector_screen[i][j]=0;    
    
    //ALEATORIZAMOS LOS BLOQUES
    bloque_activar(X_FICHA_NUEVA,Y_FICHA_NUEVA,juego->bloque_actual);
    bloque_activar(X_FICHA_SIGUIENTE,Y_FICHA_SIGUIENTE,juego->bloque_siguiente);
    juego->lineas_completadas=0;
    configuracion_cargar(&juego->config);
    juego->velocidad=juego->config.vel_ini;
    juego->puntaje=0;
}

void juego_cargar_puntaje_alto(Juego *juego){
    FILE *file;
	
	//First try to load the hiscore from the vmu
    #ifdef DREAMCAST
		char* data;
		file_t fd;
		int filesize;
		if ((fd = fs_open("/vmu/a1/blineahi", O_RDONLY)) == -1)
		{
			printf("error opening VMU A1, no found blineahi.\n");
		}
		else{
			filesize = fs_total(fd);
			data = (char*)malloc(filesize);

			//Go to the starting position of the data
			//Caution, vmu is composed by header (128) + 1 icon (512)
			//SEEK_SET (absolute position), SEEK_CUR (relative position)
			fs_seek(fd,128+512, SEEK_SET);
			fs_read(fd, data, filesize);

			// Save buffer into a RAM file
			if ((fd = fs_open("/ram/pmayor.dat", O_WRONLY|O_CREAT|O_TRUNC)) == -1)
			{
				printf("Can't create RAM file from VMU.\n");
			}
			else{
				fs_write(fd, data, filesize);
				fs_close(fd);

				// Free unused memory
				free(data);
			}
		}
    #endif
	
	#ifdef DREAMCAST
		file=fopen("/ram/pmayor.dat","rb");
	#else
		file=fopen("configuraciones/pmayor.dat","rb");
	#endif
	
    if(file==NULL){
        juego->mayor_puntaje=0;
    }else{
        fread(&(juego->mayor_puntaje),sizeof(int),1,file);
        fclose(file);
    }
}

void juego_guardar_puntaje(Juego *juego){
    FILE *file;
	
	#ifdef DREAMCAST
		file=fopen("/ram/pmayor.dat","wb");
	#else
		file=fopen("configuraciones/pmayor.dat","wb");
	#endif
	
    file=fopen("configuraciones/pmayor.dat","wb");
    fwrite(&(juego->puntaje),sizeof(int),1,file);
    fclose(file);
	
	#ifdef DREAMCAST
		//Code to save to VMU!
		vmu_pkg_t pkg;
		uint8 *pkg_out;
		int pkg_size;
		file_t ft;

		//Temporal for reading the file
		file_t filedc;
		int data_size;
		char *datasave;

		// Open file and copy to buffer
		filedc = fs_open("/ram/pmayor.dat", O_RDONLY);
		data_size = fs_total(filedc);
		datasave = (char *)malloc(data_size+1);
		fs_read(filedc, datasave, data_size);
		fs_close(filedc);

		//Make the package to the VMU.
		strcpy(pkg.desc_short, "blineahi");
		strcpy(pkg.desc_long, "BalonLinea HiScore");
		strcpy(pkg.app_id, "blineahi");
		pkg.icon_cnt = 1;
		memcpy((void *)&pkg.icon_pal[0],(void *)&vmu_icongame_pal,32);
		pkg.icon_data = (const uint8*)&vmu_icongame_img;
		pkg.icon_anim_speed = 0;
		pkg.eyecatch_type = VMUPKG_EC_NONE;
		pkg.data_len = data_size;
		pkg.data = (const uint8*) datasave;

		vmu_pkg_build(&pkg, &pkg_out, &pkg_size);

		fs_unlink("/vmu/a1/blineahi");
		ft = fs_open("/vmu/a1/blineahi", O_WRONLY);
		if (!ft) {
			printf("error writing\n");
			return;
		}
		fs_write(ft, pkg_out, pkg_size);
		fs_close(ft);

		// Free unused memory
		free(datasave);
	#endif
}
void accionar_selected_juego(Juego * juego){						
    switch(juego->selected)
		{
			case JUEGO_OPCION_REANUDAR:
				juego->estado=JUEGO_RUN;
				break;
			case JUEGO_OPCION_REINICIAR:
				juego_reiniciar(juego);
				juego->estado=JUEGO_RUN;
				break;
			case JUEGO_OPCION_MENU_PAUSA:
				aplicacion_cambiar_interfaz(juego->app,INTERFAZ_MENU);
				break;
			case JUEGO_OPCION_GUARDAR_SALIR:
				juego_guardar(juego);
				aplicacion_cambiar_interfaz(juego->app,INTERFAZ_MENU);
		}
}
void juego_procesar_eventos(Juego *juego)
{
    // Lectura de eventos
    static SDL_Event eventos;
    
    		while (SDL_PollEvent(&eventos))
			{
                  
    			// evento de cierre del programa
    			    if(eventos.type==SDL_QUIT){
                        aplicacion_cerrar(juego->app);
                        return;
                    }
                    else if(eventos.type==SDL_KEYDOWN)
					{
                        if(eventos.key.keysym.sym==SDLK_RETURN && eventos.key.keysym.mod & SDLK_LALT)
                        {
            				juego->app->pantalla=iniciar_modo();
                        }else if(eventos.key.keysym.sym==SDLK_ESCAPE){
                              aplicacion_cambiar_interfaz(juego->app,INTERFAZ_MENU);
                              return;
                        }
                
                        switch (juego->estado)
						{
                            
                            case JUEGO_PAUSADO:
                                switch(eventos.key.keysym.sym)
								{
									case SDLK_DOWN:
										if(juego->selected<JUEGO_OPCION_GUARDAR_SALIR)
											juego->selected++;
										break;
									case SDLK_UP:
										if(juego->selected>0)
											juego->selected--;
										break;
                                }
                                
                                break;
                                
                            case JUEGO_ACABADO:
                                switch(eventos.key.keysym.sym)
								{
                                    
                                    case SDLK_DOWN:
                                        if(juego->selected<1)
                                            juego->selected++;
                                        break;
                                    case SDLK_UP:
                                        if(juego->selected>0)
                                            juego->selected--;
                                        break;
                                }
                                
                                break;
                                
                        }
                    }else if(eventos.type==SDL_KEYUP&&eventos.key.keysym.sym==SDLK_RETURN)
                    {
                        switch (juego->estado)
						{
                            
                            case JUEGO_PAUSADO:
                               accionar_selected_juego(juego);
                                break;
                                
                            case JUEGO_ACABADO:
                                switch(juego->selected)
								{
                                    case JUEGO_OPCION_MENU_ACABADO_REINICIAR:
                                        if(juego->puntaje>juego->mayor_puntaje)
                                            juego_guardar_puntaje(juego);
                                        juego_reiniciar(juego);
                                        juego->estado=JUEGO_RUN;
                                        break;
                                    case JUEGO_OPCION_MENU_ACABADO_MENU:
                                        if(juego->puntaje>juego->mayor_puntaje)
                                            juego_guardar_puntaje(juego);
                                        aplicacion_cambiar_interfaz(juego->app,INTERFAZ_MENU);
                                        break;
                                }

                                break;
                                
                            case JUEGO_RUN:
                                juego->estado=JUEGO_PAUSADO;
                                break;
                        }//fin switch
                     }//fin else if
            }
}
                        

void juego_ciclo_logico(Juego *juego){
    static SDL_bool en_el_piso=SDL_FALSE;
  	static int delay_bajar=0,mantiene_tecla_presionada=0;
  	static int MantieneTeclaLateral=0,DelayMoverTecla=0,MaxDelayMoverTecla=10;
  	Uint8 *keys;
  	
  	delay_bajar++;
    switch(juego->estado){
        case JUEGO_RUN:
            keys=SDL_GetKeyState(NULL); //se obtiene el ESTADO DEL TECLADO
            
            if(!mantiene_tecla_presionada){
                    if (keys[SDLK_UP]){
                        juego->bloque_actual->rotacion=(juego->bloque_actual->rotacion<3)?juego->bloque_actual->rotacion+1:0;
                         
                         //comprobamos la colision con la barra lateral izquierda
                         static int left,previusX;
                         left=bloque_getleft(juego->bloque_actual);
                         previusX=juego->bloque_actual->x;
                         if(left<0)
                            juego->bloque_actual->x+=abs(left);
                            
                         //comprobamos la colision con la barra lateral derecha
                         if(bloque_getright(juego->bloque_actual)>W_JUEGO+EJE_X_JUEGO){
                            juego->bloque_actual->x=W_JUEGO+EJE_X_JUEGO-W_H_BLOQUE*5;
                         }
                                                  
                        if(espacio_ocupado(juego->vector_screen,juego->bloque_actual)){
                            juego->bloque_actual->rotacion--;
                            juego->bloque_actual->x=previusX;
                        }
                        
                    }
                    if (keys[SDLK_SPACE]){	
                        while(!espacio_ocupado(juego->vector_screen,juego->bloque_actual))
                			juego->bloque_actual->y+=W_H_BLOQUE;
            			juego->bloque_actual->y-=W_H_BLOQUE;
                        en_el_piso=SDL_TRUE;
                    }
                            
                    if (keys[SDLK_LEFT]){	
                        if((MantieneTeclaLateral&&(++DelayMoverTecla>=MaxDelayMoverTecla))||!MantieneTeclaLateral){
                        	juego->bloque_actual->x-=W_H_BLOQUE;
                        	if(espacio_ocupado(juego->vector_screen,juego->bloque_actual)) 
                        	   juego->bloque_actual->x+=W_H_BLOQUE;
                        	if(MantieneTeclaLateral){
                            	   MaxDelayMoverTecla-=5;
                            	   DelayMoverTecla=0;
                                }
                            }
                   }   
                    if (keys[SDLK_RIGHT])
            		{
                        if((MantieneTeclaLateral&&(++DelayMoverTecla>=MaxDelayMoverTecla))||!MantieneTeclaLateral){
                        	juego->bloque_actual->x+=W_H_BLOQUE;
                        	if(espacio_ocupado(juego->vector_screen,juego->bloque_actual)) 
                        	   juego->bloque_actual->x-=W_H_BLOQUE;
                        	if(MantieneTeclaLateral){
                        	   MaxDelayMoverTecla-=5;
                        	   DelayMoverTecla=0;
                                }
                            }
            		}
            		
                    if (keys[SDLK_DOWN])
                        delay_bajar=90-juego->velocidad*8;
            }
            mantiene_tecla_presionada=keys[SDLK_UP]||keys[SDLK_SPACE];
            MantieneTeclaLateral=keys[SDLK_LEFT]||keys[SDLK_RIGHT];
            if(!MantieneTeclaLateral)
                MaxDelayMoverTecla=20;
                
        
              // se baja el bloque
              if (!(delay_bajar % (90-juego->velocidad*8))||en_el_piso){
                    juego->bloque_actual->y+=W_H_BLOQUE;
                    delay_bajar=0;
                    en_el_piso=SDL_FALSE;
                    
                    int pasa_pantalla=espacio_ocupado(juego->vector_screen,juego->bloque_actual);
                    
                    //si esta en el piso
                	if(pasa_pantalla){
                            //guardamos la ficha y ponemos una ficha con el mismo formato que la siguiente y creamos una nueva
                    	   juego->bloque_actual->y-=W_H_BLOQUE;
                    	   guardar_bloque(juego->vector_screen,juego->bloque_actual);//plasmamos la ficha en el array de la screen
                    	   copiar_bloques(juego->bloque_siguiente,juego->bloque_actual);
                    	   
                    	   bloque_posicionar(juego->bloque_actual,X_FICHA_NUEVA,Y_FICHA_NUEVA);
                           bloque_activar(X_FICHA_SIGUIENTE,Y_FICHA_SIGUIENTE,juego->bloque_siguiente);
                           if(preparar_lineas_llenas(juego->vector_screen)){
                                borrar_lineas_preparadas(juego);
                            }//fin si preparar lineas
                            
                            if(espacio_ocupado(juego->vector_screen,juego->bloque_actual)){
                               juego->estado=JUEGO_ACABADO;
                               juego->selected=0;
                            }
                            
                    }
              } 
                bloque_animacion_rebote(juego->bloque_siguiente);
                int i;
                for(i=0;i<W_JUEGO/20*4;i++){
                  if(juego->pelotas[i].activo)
                     animar_pelota(&juego->pelotas[i]);
                  else
                    break;
                }
			break;
		}
}



void juego_dibujar_datos(Juego *juego)
{
     /*DIBUJAMOS LOS DATOS*/
    char impresion[8];
	#ifdef DREAMCAST
		//Yeah, as usual, recolocate for 640x480
		colocar_en_formato_decimal(impresion,juego->lineas_completadas,8);
		mostrar_msg(juego->app->pantalla,juego->app->galeria->fuentes_imagen[1],457,180,impresion);

		colocar_en_formato_decimal(impresion,juego->puntaje,8);
		mostrar_msg(juego->app->pantalla,juego->app->galeria->fuentes_imagen[1],457,248,impresion);

		colocar_en_formato_decimal(impresion,juego->mayor_puntaje,8);
		mostrar_msg(juego->app->pantalla,juego->app->galeria->fuentes_imagen[1],457,313,impresion);

	#else
		colocar_en_formato_decimal(impresion,juego->lineas_completadas,8);
		mostrar_msg(juego->app->pantalla,juego->app->galeria->fuentes_imagen[1],572,225,impresion);

		colocar_en_formato_decimal(impresion,juego->puntaje,8);
		mostrar_msg(juego->app->pantalla,juego->app->galeria->fuentes_imagen[1],572,310,impresion);

		colocar_en_formato_decimal(impresion,juego->mayor_puntaje,8);
		mostrar_msg(juego->app->pantalla,juego->app->galeria->fuentes_imagen[1],572,392,impresion);
	#endif
}
void juego_dibujar_opciones(Juego *juego)
{
     static int paso_mayor_puntaje,delay;
    switch(juego->estado){
        case JUEGO_PAUSADO:
             imprimir_desde_grilla(juego->app->galeria->txt_reanudar,juego->selected==JUEGO_OPCION_REANUDAR,juego->app->pantalla,223,182,2,1);
             imprimir_desde_grilla(juego->app->galeria->txt_reiniciar,juego->selected==JUEGO_OPCION_REINICIAR,juego->app->pantalla,234,232,2,1);
             imprimir_desde_grilla(juego->app->galeria->txt_menu,juego->selected==JUEGO_OPCION_MENU_PAUSA,juego->app->pantalla,264,282,2,1);
             imprimir_desde_grilla(juego->app->galeria->txt_guardar_salir,juego->selected==JUEGO_OPCION_GUARDAR_SALIR,juego->app->pantalla,138,329,2,1);
             
             break;
        case JUEGO_ACABADO:
             imprimir_desde_grilla(juego->app->galeria->txt_reiniciar,juego->selected==0,juego->app->pantalla,223,182,2,1);
             imprimir_desde_grilla(juego->app->galeria->txt_menu,juego->selected==1,juego->app->pantalla,234,232,2,1);
             
            if(juego->puntaje>juego->mayor_puntaje){
                imprimir_desde_grilla(juego->app->galeria->txt_puntaje_mayor,paso_mayor_puntaje,juego->app->pantalla,74,373,2,1);
                delay++;
                if(delay>5){
                    delay=0;
                    paso_mayor_puntaje=!paso_mayor_puntaje;
                }
            }
            break;
        }
}

void juego_ciclo_grafico(Juego *juego,SDL_Surface * screen)
{//esto aun no esta optimizado, aun esta a lo bestia (igual que todos los volcados demas...   :-p)

    //borramos todo
    SDL_BlitSurface(juego->app->galeria->fondo_juego,NULL,screen,NULL);
    
	#ifdef DREAMCAST
	dibujar_objeto(juego->app->galeria->tabla_bottom,0,462,screen);
	#else
    dibujar_objeto(juego->app->galeria->tabla_bottom,0,580,screen);
	#endif
    juego_dibujar_datos(juego);
    bloque_dibujar(juego->bloque_actual,screen);//,juego->galeria->grilla_bloques,juego->app->screen);
    bloque_dibujar(juego->bloque_siguiente,screen);
    dibujar_vector_screen(juego->vector_screen,juego->app->galeria->grilla_bloques,screen);

    int i;
    for(i=0;i<W_JUEGO/20*4;i++)
    {
      if(juego->pelotas[i].activo)
         imprimir_desde_grilla(juego->app->galeria->grilla_bloques,juego->pelotas[i].id,screen,juego->pelotas[i].x,juego->pelotas[i].y,1,7);
      else
        break;
    }

    if(juego->estado!=JUEGO_RUN)
            juego_dibujar_opciones(juego);
}

void juego_terminar(Juego * juego){
     free(juego->bloque_actual);
     free(juego->bloque_siguiente);
}
