#include "bloque.h"


Bloque * bloque_crear(Aplicacion * Aplicacion){
     Bloque * nuevo;
     nuevo=(Bloque *)malloc(sizeof(Bloque));
     if(!nuevo){
         fprintf(stderr,"no hay memoria suficiente para almacenar estructura:Bloque\n");
         exit(1);
     }
     nuevo->app=Aplicacion;
     return nuevo;
}
void bloque_activar(Sint16 x,Uint16 y,Bloque *bloque)
{
   bloque->x=x;
   bloque->y=y;
   bloque->tipo=rand()%_BLOQUES;
   bloque->rotacion=rand()%4;
   bloque->vel_y=0;
}

int bloque_getdown(Bloque * bloque){
     int i,j,y_mas_abajo=-1,y_tentativa;
     for (i=0;i<5;i++){
    	 for(j=0;j<5;j++){
                if(bloque->app->plantillas[bloque->tipo][bloque->rotacion][i*5+j]){
                    y_tentativa=bloque->y+i*W_H_BLOQUE+W_H_BLOQUE;
                    if(y_tentativa>y_mas_abajo)
                         y_mas_abajo=y_tentativa;
                    }
    	}
    }
    return y_mas_abajo;
}
int bloque_getleft(Bloque * bloque){
     int i,j,xMasALaDerecha=10000,xMasALaDerechaTentativa;
     for (i=0;i<5;i++){
    	 for(j=0;j<5;j++){
                if(bloque->app->plantillas[bloque->tipo][bloque->rotacion][i*5+j]){
                    xMasALaDerechaTentativa=bloque->x+W_H_BLOQUE*j;
                    if(xMasALaDerechaTentativa<xMasALaDerecha)
                         xMasALaDerecha=xMasALaDerechaTentativa;
                    }
    	}
    }
    return xMasALaDerecha;
}

int bloque_getright(Bloque * bloque){
     int i,j,xMasALaDerecha=0,xMasALaDerechaTentativa=0;
     for (i=0;i<5;i++){
    	 for(j=0;j<5;j++){
                if(bloque->app->plantillas[bloque->tipo][bloque->rotacion][i*5+j]){
                    xMasALaDerechaTentativa=bloque->x+W_H_BLOQUE*j+i;
                    if(xMasALaDerechaTentativa>xMasALaDerecha)
                         xMasALaDerecha=xMasALaDerechaTentativa;
                    }
    	}
    }
    return xMasALaDerecha;
}

void bloque_animacion_rebote(Bloque * bloque){
     //efecto para que el balon rebote(codigo base: Hugo Ruscitii -http://www.loosersjuegos.com.ar- )
    
	bloque->vel_y += 0.1;
	#ifdef DREAMCAST
	if (bloque_getdown(bloque) >=150&&bloque->vel_y>0)
	#else
	if (bloque_getdown(bloque) >=184&&bloque->vel_y>0)
	#endif
	{
		bloque->vel_y *= -1;
	}
	else{
		bloque->y+= (int) bloque->vel_y;
	}

}


void bloque_dibujar(Bloque *bloque,SDL_Surface * screen){
    register int i,j;
    SDL_Rect dest={bloque->x,bloque->y,W_H_BLOQUE,W_H_BLOQUE};
    SDL_Rect src={bloque->tipo*W_H_BLOQUE,0,W_H_BLOQUE,W_H_BLOQUE};
    
     for (i=0;i<5;i++){
    	 for(j=0;j<5;j++){
                if(bloque->app->plantillas[bloque->tipo][bloque->rotacion][i*5+j]){
                    dest.x=bloque->x+W_H_BLOQUE*j;
                    dest.y=bloque->y+W_H_BLOQUE*i;
                    SDL_BlitSurface(bloque->app->galeria->grilla_bloques,&src,screen,&dest);
                }
    	}
    }
}


void copiar_bloques(Bloque *copiar,Bloque *pegar){
    pegar->tipo=copiar->tipo;
    pegar->rotacion=copiar->rotacion;
}

void bloque_posicionar(Bloque * bloque,int x,int y){
     bloque->x=x;
     bloque->y=y;
}
