/************************************************************************/
/*																		*/
/*		Name:		FM.C  												*/
/*		Project:	Football Manager Remake								*/
/*		Purpose:	Main Program       									*/
/*		Author:		Paul Robson											*/
/*		Created:	12th December 2001									*/
/*		Updated:	21st December 2001									*/
/*																		*/
/************************************************************************/

#include "fm.h"                                   /* Standard header */

#ifdef DREAMCAST
	#include <kos.h>
	#include <zlib/zlib.h> //VMU Compression
	#include "dreamcast_icon.h"
#endif

GAME g;                                           /* The entire game is here ! */

// static void FixFixtureList(GAME *g);

/************************************************************************/
/*																		*/
/*								Main Program							*/
/*																		*/
/************************************************************************/

int RunFootballManager(int argc,char *argv[])
{
    FILE *f;
    char *FileName;
    IOInitialise();                               /* Initialise driver */
    INITNewGame(&g);                              /* Load game.dat etc. */
    MISCTitle();                                  /* Display title page */
	
	//Dreamcast: Load from VMU (1 slot)
	#ifdef DREAMCAST
		DC_LoadFromVMU("/ram/fm0.sav");
	#endif
	
    FileName = MISCGetFileName('L');              /* Load file ? */
    if (FileName != NULL)                         /* If so, load the file in */
    {
        f = fopen(FileName,"rb");
        MASSERT(f != NULL);
        fread(&g,sizeof(GAME),1,f);
        fclose(f);
    /* FixFixtureList(&g); */
    }
    else
    {
        MISCSelectTeam(&g);                       /* Select a team to play with */
        MENUSkillLevel(&g);                       /* Select the skill level */
        INITNewSeason(&g);                        /* Start a new season */
    }
    while (g.Sacked == 0 &&                       /* While keeping on playing */
        MENUMain(&g) == 0)
    {
        MDRun(&g);                                /* Play one game */
        MISCBills(&g);                            /* Pay bills and so on */
        if (g.Sacked == 0)                        /* Sacked on financial grounds */
        {
            MISCTransfers(&g);                    /* Buy players ? */
            EOSEndSeason(&g);                     /* End of Season Code */
        }
    }
    if (g.Sacked == 0)                            /* Not sacked ! */
    {
        FileName = MISCGetFileName('S');          /* Get save slot */
        if (FileName != NULL)                     /* If save selected, save */
        {
            f = fopen(FileName,"wb");
            MASSERT(f != NULL);
            fwrite(&g,sizeof(GAME),1,f);
            fclose(f);
			//Dreamcast: Save to VMU
			#ifdef DREAMCAST
				DC_SaveToVMU(FileName);
			#endif
        }
    }
	printf("Exiting...\n");
	#ifndef DREAMCAST
		IOTerminate();                                /* Terminate Driver */
	#endif
    return 0;
}


#ifdef DREAMCAST

int DC_LoadFromVMU(char *FileName) {
    
	int file;
    int filesize;
    unsigned long unzipsize;
    uint8* data;
    uint8* unzipdata;
    vmu_pkg_t pkg;
	
	// Remove VMU header
    file = fs_open("/vmu/b1/matchday", O_RDONLY);
    if(file == 0) return -1;
    filesize = fs_total(file);
    if(filesize <= 0) return -1;
    data = (uint8*)malloc(filesize);
    fs_read(file, data, filesize);
    vmu_pkg_parse(data, &pkg);
    fs_close(file);

    // Allocate memory for the uncompressed data
    unzipdata = (uint8 *)malloc(65536);
    unzipsize = 65536;

    // Uncompress the data to the CWD
    uncompress(unzipdata, &unzipsize, (uint8 *)pkg.data, pkg.data_len);
    fs_unlink(FileName); //clear previous data
	
    file = fs_open(FileName, O_WRONLY);
    fs_write(file, unzipdata, unzipsize);
    fs_close(file);

    // Free unused memory
    free(data);
    free(unzipdata);
	
    return 0;
}

int DC_SaveToVMU(char *FileName) {
    vmu_pkg_t pkg;
    uint8 *pkg_out;
    int pkg_size;
	
	//Zip data
	unsigned long zipsize = 0;
    uint8 *zipdata;
	
    //Temporal for reading the file
    file_t file;
    int data_size;
    uint8 *datasave;
	
	// Open file and copy to buffer
    file = fs_open(FileName, O_RDONLY);
    data_size = fs_total(file);
    datasave = (uint8*)malloc(data_size+1);
    fs_read(file, datasave, data_size);
    fs_close(file);
    fs_unlink(FileName);
	
	// Allocate some memory for compression
    zipsize = data_size * 2;
    zipdata = (uint8*)malloc(zipsize);
	
    // The compressed save
    compress(zipdata, &zipsize, datasave, data_size);
	//zipsive has changed its size to the compress data!

    //Make the package to the VMU.
    strcpy(pkg.desc_short, "matchday");
    strcpy(pkg.desc_long, "FM Save (Slot 0)");
    strcpy(pkg.app_id, "matchday");
    pkg.icon_cnt = 1;
    memcpy((void *)&pkg.icon_pal[0],(void *)&vmu_icon_pal,32);
    pkg.icon_data = (const uint8*)&vmu_icon_img;
    pkg.icon_anim_speed = 0;
    pkg.eyecatch_type = VMUPKG_EC_NONE;
    pkg.data_len = zipsize;
    pkg.data = (const uint8*) zipdata;

    vmu_pkg_build(&pkg, &pkg_out, &pkg_size);

	//Delete previous save
    fs_unlink("/vmu/b1/matchday");
	
	file_t ft;
    ft = fs_open("/vmu/b1/matchday", O_WRONLY);
    if (!ft) {
        printf("error writing\n");
        return -1;
    }
    fs_write(ft, pkg_out, pkg_size);
    fs_close(ft);

    // Free unused memory
    free(zipdata);
    free(pkg_out);
    free(datasave);
	
	return 0;
}
#endif
