/*

    Dodgin' Diamond 2, a shot'em up arcade
    Copyright (C) 2003,2004 Juan J. Martinez <jjm@usebox.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License Version 2 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#include"SDL.h"
#include"SDL_mixer.h"
#include"menu.h"
#include"engine.h"
#include"cfg.h"
#include"control.h"
#include"SDL_plus.h"

extern SDL_Surface *screen, *gfx;
extern Mix_Chunk *efx[8];
extern Mix_Music *bgm;
extern int sound;

int delay =0;	//slow controls down

#ifndef DELAY
#define DELAY	25//this is the amount to delay things by
#endif

extern pDesc player[2];

extern score hiscore[10];
extern cfg conf;

extern float scroll,scroll2;

void soundLoad(void);

void
drawGetName(char *name, int place, int playern)
{
	char buffer[64];

	/* erase the screen */
	SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,0,0,0));

	writeCString(gfx, screen, 90, 40, "congratulations", 0);

	sprintf(buffer,"player %i with score %.6li",playern,player[playern-1].score);
	writeCString(gfx, screen, 10, 80, buffer, 1);

	switch(place) {
		default:
			sprintf(buffer,"you got %ith place",place);
		break;
		case 1:
			sprintf(buffer,"you got %ist place",place);
		break;
		case 2:
			sprintf(buffer,"you got %ind place",place);
		break;
		case 3:
			sprintf(buffer,"you got %ird place",place);
		break;
	}
	writeCString(gfx, screen, 10, 97, buffer, 1);

	writeCString(gfx, screen, 10, 131, "enter your name", 0);

	if(name[0])
		sprintf(buffer,"%s+",name);
	else
		strcpy(buffer,"+");

	writeCString(gfx, screen, 175, 131, buffer, 1);

	SDL_Flip(screen);
}

int
getName(char *name, int place, int playern)
{
	int pos=0, i=0;
	char ckey='a';

	name[pos]=ckey;
	name[pos+1]=0;	

	drawGetName(name,place,playern);

	cont_state_t* state;
	maple_device_t* dev;
	dev = maple_enum_dev (playern-1,0);
	
	delay=2;
	delay*=DELAY;

	while(1) {
		state = (cont_state_t*) maple_dev_status (dev);

		if (delay>2){
			delay--;
			SDL_Delay(2);
		}
		else if((state->buttons & CONT_A)||(state->buttons & CONT_DPAD_RIGHT)||(state->joyx >=96)){
			delay*=DELAY;
			if(pos<8) {
				name[pos]=ckey;
				pos++;
				name[pos]=0;
				drawGetName(name,place,playern);
				ckey='a';				
			}
		}
		else if((state->buttons & CONT_DPAD_UP)||(state->joyy <=-96)){
			delay*=DELAY;
			ckey++;
			if(ckey>'z')
				ckey='0';
			if(ckey-1=='9')
				ckey='a';

			name[pos]=ckey;
			name[pos+1]=0;
			drawGetName(name,place,playern);					
		}
		else if((state->buttons & CONT_DPAD_DOWN)||(state->joyy >=96)){
					delay*=DELAY;
					ckey--;

					if(ckey<'0')
						ckey='z';
					if(ckey+1=='a')
						ckey='9';

					name[pos]=ckey;
					name[pos+1]=0;
					drawGetName(name,place,playern);					
		}
		else if(state->buttons & CONT_START){
			if(name[0]) {
				/* pirutupiiii */
				if(sound && efx[7])
					Mix_PlayChannel(-1,efx[7],0);
				return 1;
			}
		}
		else if(state->buttons & CONT_B){
			delay*=DELAY;
			if(pos>0) {
				pos--;
				name[pos]=0;
				drawGetName(name,place,playern);
			}			
		}
		
	}

	return 0;
}

void
drawHiscores(int max)
{
	int i;
	SDL_Rect a,b;

	/* erase the screen */
	SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,0,0,0));

	/* DD2 characters */
	a.x=60;
	a.y=5;
	b.x=450;
	b.y=43;
	b.w=211;
	b.h=190;
	SDL_BlitSurface(gfx, &b, screen, &a);

	/* header */
	writeCString(gfx, screen, 80, 2, "the hall of fame", 1);

	for(i=0;i<max;i++) {
		writeNumber(gfx, screen, 10, 23+i*17, i+1, 2);
		writeCString(gfx, screen, 30, 20+i*17, hiscore[i].name, 0);
		writeCString(gfx, screen, 180, 20+i*17, "st",0);
		writeNumber(gfx, screen, 200, 23+i*17, hiscore[i].stage,2);
		writeCString(gfx, screen, 236, 20+i*17, "sc",0);
		writeNumber(gfx, screen, 260, 23+i*17, hiscore[i].score,6);
	}

	SDL_Flip(screen);
}

int
hiscores()
{
	Uint32 tick;

	cont_state_t* state;
	maple_device_t* dev;
	dev = maple_enum_dev (0,0);

	int i;

	for(i=0;i<10;i++) {
		drawHiscores(i+1);
		SDL_Delay(300);
	}

	tick=SDL_GetTicks();
	while(1) {
		state = (cont_state_t*) maple_dev_status (dev);
		if(state->buttons & CONT_A )
			return 1;

		/* wait some time and return */
		if(SDL_GetTicks()-tick>10000) {
			/* pirutupiiii */
			if(sound && efx[7])
				Mix_PlayChannel(-1,efx[7],0);
			return 1;
		}
	}

	return 0;
}

void
drawMenu(int option)
{
	SDL_Rect a,b;

	/* erase the screen */
	SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,0,0,0));

	/* BETA */
	a.x=77;
	a.y=20;
	b.x=100;
	b.y=46;
	b.w=166;
	b.h=15;
	SDL_BlitSurface(gfx, &b, screen, &a);

	/* options */
	writeCString(gfx, screen, 105, 50,  "one player", (option==1));
	writeCString(gfx, screen, 105, 67,  "two players", (option==2));
	writeCString(gfx, screen, 105, 94, "hall of fame", (option==3));
	writeCString(gfx, screen, 105, 138, "about", (option==4));
	writeCString(gfx, screen, 105, 155, "exit game", (option==5));
	writeCString(gfx, screen, 20 , 184, "screamcast.net",0);

	/* some credit */
	a.x=154;
	a.y=184;
	b.x=268;
	b.y=57;
	b.w=166;
	b.h=16;
	SDL_BlitSurface(gfx, &b, screen, &a);

	SDL_Flip(screen);
}

int
menu()
{
	
	int option=1, i;
	cont_state_t* state;
	maple_device_t* dev;
	dev = maple_enum_dev (0,0);

	/* pirutupiiii */
	if(efx[7])
		Mix_PlayChannel(-1,efx[7],0);

	drawMenu(option);

	/* some dirty init */
	scroll=scroll2=0;
	delay = 50;
	while(1) {
		state = (cont_state_t*) maple_dev_status (dev);
		drawMenu(option);
		if (delay>0)
			delay--;
		else if(state->buttons & CONT_A ){
			delay+=DELAY;
			switch(option) {
				default:
					break;
				case 1:
					player[0].shield=10;
					player[1].shield=0;
					player[0].score=player[1].score=0;
					player[0].stage=player[1].stage=0;
					return 1;
				
				case 2:
					player[0].shield=10;
					player[1].shield=10;
					player[0].score=player[1].score=0;
					player[0].stage=player[1].stage=0;
					return 1;
				
				case 3:
					hiscores();
					drawMenu(option);
				break;				
				
				case 4:
					if(!credits())
						return 0;
					drawMenu(option);
				break;
				
				case 5:
					return 0;
				break;
			}
		}		
		else if((state->buttons & CONT_DPAD_UP)||(state->joyy <=-64)){
			delay+=DELAY;
			option--;
			if(option<1)
				option=5;
			drawMenu(option);
		}
		else if((state->buttons & CONT_DPAD_DOWN)||(state->joyy >=64)){
			delay+=DELAY;
			option++;
			if(option>5)
				option=1;
			drawMenu(option);
		}
	}
	return 0;
}

void
drawCredits()
{
	SDL_Rect a,b;
	
	/* erase the screen */
	SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,0,0,0));

	/* BETA */
	a.x=77;
	a.y=20;
	b.x=100;
	b.y=46;
	b.w=166;
	b.h=15;
	SDL_BlitSurface(gfx, &b, screen, &a);

	writeCString(gfx, screen, 20, 50, "this is dd2 version dc2.0.", 0);
	writeCString(gfx, screen, 20, 80, "main author", 1);
	writeCString(gfx, screen, 40, 105, "juan j. martinez", 0);
	writeCString(gfx, screen, 40, 120, "ported by: quzar", 0);
	writeCString(gfx, screen, 40, 140, "thanks you for playing...", 0);
	
	SDL_Flip(screen);
}

int
credits()
{
	Uint32 tick;

	cont_state_t* state;
	maple_device_t* dev;
	dev = maple_enum_dev (0,0);

	drawCredits();
	SDL_Delay(600);
	tick=SDL_GetTicks();
	while(1) {
		state = (cont_state_t*) maple_dev_status (dev);
		if(state->buttons & CONT_A )
			return 1;

		/* wait some time and return */
		if(SDL_GetTicks()-tick>10000) {
			/* pirutupiiii */
			if(sound && efx[7])
				Mix_PlayChannel(-1,efx[7],0);
			return 1;
		}
	}

	return 0;
}


