/*

    Dodgin' Diamond 2, a shot'em up arcade
    Copyright (C) 2003,2004 Juan J. Martinez <jjm@usebox.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License Version 2 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "main.h"
#include "control.h"
#include "SDL_plus.h"
extern bool Pause;
int delays[2] = {0,0};

cont_state_t* state;
maple_device_t* dev[2];

void control_player_init(void){
  dev[0] = maple_enum_dev (0,0);
  dev[1] = maple_enum_dev (1,0);
  return;
}

void control_player(pDesc *p, int num)
{
	if(Pause)
		return;

	state = (cont_state_t*) maple_dev_status (dev[num]);
	
	if(state->buttons & CONT_A ){
		if(delays[num]>0){
			delays[num]--;
			p->fire = 0;
		}
		else{
			p->fire	= 1;
			delays[num]++;
		}
	}
	else
		p->fire = 0;
	

	if((state->buttons & CONT_DPAD_UP)||(state->joyy <=-64)){
		p->incy=-1;
	}
	else if((state->buttons & CONT_DPAD_DOWN)||(state->joyy >=64)){
		p->incy=1;
	}
	else
		p->incy=0;

	if((state->buttons & CONT_DPAD_LEFT)||(state->joyx <=-64)){
		p->incx=-1;
	}
	else if((state->buttons & CONT_DPAD_RIGHT)||(state->joyx >=64)){
		p->incx=1;
	}
	else
		p->incx=0;

	return;
}
