/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * The widget is defined as the basic screen entity. I.e. contrains drawing, animate,
 * control interfaces.
 * 
 */
 
#ifndef IWidget_H
#define IWidget_H

#include "WinToolKitGeneral.h"

class IWidget
{

protected:

	// Size / position of the widget
	Uint32 x;
	Uint32 y;
	Uint32 width;
	Uint32 height;
	
	Uint8* keyStates;
	bool active;
	bool visible;
	bool mouseOver;
	
public:

	IWidget()
	{
		this->keyStates = SDL_GetKeyState(NULL);
		this->x = 0;
		this->y = 0;
		this->width = 0;
		this->height = 0;
		this->active = false;
		this->visible = true;	
	}
	
	IWidget(Point pointTopLeft, Point pointBottomRight)
	{
		this->keyStates = NULL;
		this->x = (Uint32)pointTopLeft.x;
		this->y = (Uint32)pointTopLeft.y;
		this->width = (Uint32)(pointBottomRight.x - pointTopLeft.x);
		this->height = (Uint32)(pointBottomRight.y - pointTopLeft.y);
		this->active = false;
		this->visible = true;
	}

	IWidget(int x, int y)
	{
		this->keyStates = NULL;
		this->x = x;
		this->y = y;
		this->width = 0;
		this->height = 0;
		this->active = false;
		this->visible = true;
	}
	
	IWidget(int x, int y, int width, int height)
	{
		this->keyStates = NULL;
		this->x = x;
		this->y = y;
		this->width = width;
		this->height = height;
		this->active = false;
		this->visible = true;
	}
	
	// Make sure we can clean up all child classes
	virtual ~IWidget()
	{
	
	}
	
	inline void moveBy(int x, int y)
	{
		this->x += x;
		this->y += y;
	}
	
	inline void moveTo(int x, int y)
	{
		this->x = x;
		this->y = y;
	}
	
	inline bool isPointOverMe(int x, int y)
	{
		if ((Uint32)x < this->x || this->x + this->width < (Uint32)x)
			return false;
		if ((Uint32)y < this->y || this->y + this->height < (Uint32)y)
			return false;
			
		return true;
	}
	
	virtual Uint32 getWidth(){return this->width;};
	virtual void setWidth(Uint32 width){this->width = width;};
	virtual Uint32 getHeight(){return this->height;};
	virtual void setHeight(Uint32 height){this->height = height;};
	virtual Point getPosition(){return Point(this->x, this->y);};
	virtual void setPosition(Point pos){this->x = (Uint32)pos.x;this->y = (Uint32)pos.y;};
	virtual void setPosition(int x, int y){this->x = x; this->y = y;};
	
	
	// Accessors for the active / visibility
	virtual bool getActive(){return this->active;};
	virtual void setActive(bool act){this->active = act;};
	virtual bool getVisible(){return this->visible;};
	virtual void setVisible(bool vis){this->visible = vis;};
	
	virtual void animate(){};							// Move the contents for the next frame
	virtual bool pollKeyStates(){return false;};		// Process the key states
	virtual void draw(SDL_Surface* screenDest){};		// Draw the item to the given screen
	virtual bool mouseDown(int x, int y, int button){return false;};// The mouse has been pressed let the class handle it
	virtual bool mouseUp(int x, int y, int button){return false;};
	virtual bool mouseMove(int x, int y){return false;};
	virtual bool keyPress(SDLKey key, SDLMod mod, Uint16 character){return false;}; // A key has been pressed let the class handle it
	
};

#endif
