/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
#ifndef FONTMANAGER_H
#define FONTMANAGER_H

#include "Font.h"
#include "WinToolKitGeneral.h"

class FontManager
{
	
private:

	// Singleton
	static FontManager* _instance;
	
	FontManager();
	
	List<Font*> fontsList;
	
public:

	virtual ~FontManager();
	
	static FontManager* Instance();
	
	Font* getFont(const char* fontFileName);
	
	void drawText(const char* fontFileName, SDL_Surface* surface, Rect boundingBox,  VerticalAlign vAlign, HorizontalAlign hAlign, char* text, ... );	
    Uint32 textWidth(const char* fontFileName, const char* text, ...);
    Uint32 height(const char* fontFileName);
};

#endif // FONTMANAGER_H
