/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
#include "FontManager.h"

FontManager* FontManager::_instance = (FontManager*)NULL; /// initialize static instance pointer

FontManager* FontManager::Instance()
{
	if (_instance == NULL)
	{
		_instance = new FontManager();	
	}
	return _instance;	
}

FontManager::FontManager()
{

}

FontManager::~FontManager()
{
	this->fontsList.DeleteAndRemove();
}

Font* FontManager::getFont(const char* fontFileName)
{
	// Search through the list of items for loaded fonts	
	DListIterator<Font*> ctrlIter = fontsList.GetIterator();
	ctrlIter.Start();
	while (ctrlIter.Valid())
	{
		if (strcmp(ctrlIter.Item()->fontName(), fontFileName) == 0)
		{
			return ctrlIter.Item();
		}
		ctrlIter.Forth();	
	}
	
	// Haven't found the font already loaded so try to load it now
	Font* newfont = new Font(fontFileName);
	fontsList.Append(newfont);
	return newfont;
}

void FontManager::drawText(const char* fontFileName, SDL_Surface* surface, Rect boundingBox,  VerticalAlign vAlign, HorizontalAlign hAlign, char* text, ... )
{
	Font* font = NULL;
	font = FontManager::getFont(fontFileName);
	if (font)
	{
		char string[1024];          // Temporary string
		va_list ap;               	// Pointer To List Of Arguments
		va_start(ap, text);         // Parses The String For Variables
		vsprintf(string, text, ap); // Converts Symbols To Actual Numbers
		va_end(ap);               	// Results Are Stored In Text
		
		font->drawText(surface, boundingBox, vAlign, hAlign, string);
	}
}

Uint32 FontManager::textWidth(const char* fontFileName, const char* text, ...)
{
	Font* font = NULL;
	font = FontManager::getFont(fontFileName);
	if (font)
	{
		char string[1024];          // Temporary string
		va_list ap;               	// Pointer To List Of Arguments
		va_start(ap, text);         // Parses The String For Variables
		vsprintf(string, text, ap); // Converts Symbols To Actual Numbers
		va_end(ap);               	// Results Are Stored In Text
		
		return font->textWidth(string);
	}
	return 0;
}

Uint32 FontManager::height(const char* fontFileName)
{
	Font* font = NULL;
	font = FontManager::getFont(fontFileName);
	if (font)
	{
		return font->height();
	}
	return 0;
}

