/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef DRAWING_H
#define DRAWING_H

#include "WinToolKitGeneral.h"

class Drawing
{
private:

	SDL_Surface* newsurf_fromsurf(SDL_Surface* surf, int width, int height);
	
public:

	Drawing();
	virtual ~Drawing();
	
	void static drawSurface (SDL_Surface* screen, SDL_Surface* graphic, Point position, float rotation);
	void static drawOffsetSurface (SDL_Surface* screen, SDL_Surface* graphic, Point position, float rotation, Point offset);
	void static drawOffsetSurface (SDL_Surface* screen, SDL_Surface* graphic, Point position, float rotation, int xOffsetPct, int yOffsetPct);
	void static drawArc(SDL_Surface* surf, Uint32 colour, Point centre, Point startPos, Point endPos, Rotation rot);
	void static drawArc(SDL_Surface* surf, Uint32 colour, Point centre, double startAngle, double endAngle, double radius, Rotation rot);
	void static drawCircle(SDL_Surface* surf, Uint32 colour, Point centre, int radius);
	void static drawCircle(SDL_Surface* surf, Uint32 colour, int centreX, int centreY, int radius);	
	void static circlePoints(SDL_Surface* surf, Uint32 colour, int cx, int cy, int x, int y);
	void static drawDisc(SDL_Surface* surf, Uint32 colour, Point centre, int radius);
	void static drawDisc(SDL_Surface* surf, Uint32 colour, int centreX, int centreY, int radius);
	void static drawLine(SDL_Surface* surf, Uint32 colour, Point startPos, Point endPos);
	void static drawLine(SDL_Surface* surf, Uint32 colour, int x, int y, int x2, int y2);
	void static drawRect(SDL_Surface* surf, Uint32 colour, Point topLeft, Point bottomRight);
	void static drawRect(SDL_Surface* surf, Uint32 colour, Rect size);
};

#endif // DRAWING_H





