/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
 /*
  * A combo box is simply a textbox with a listbox below it
  */

#ifndef COMBO_H
#define COMBO_H

#include "Control.h"
#include "TextBox.h"
#include "ListBox.h"

class Combo : public Control
{
private:

	// Size of the textbox
	Uint32 widthTextBox;
	Uint32 heightTextBox;
	
	// Size of the listbox
	Uint32 widthListBox;
	Uint32 heightListBox;
	
	// TextBox or list box active
	bool listActive;
	
	// Base Controls
	TextBox* textBox;
	ListBox* listBox;
	
public:

	Combo(Rect size);
	virtual ~Combo();
	
	// Wrapper functions for the text box
	
	// Wrapper functions for the list box
		
	
	// IWidget functions
	virtual void draw(SDL_Surface* screenDest);
	virtual bool mouseDown(int x, int y, int button);
	virtual bool mouseUp(int x, int y, int button);
	virtual bool mouseMove(int x, int y);
	virtual bool keyPress( SDLKey key, SDLMod mod, Uint16 character );
	
};

#endif // COMBO_H
