/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "Combo.h"

Combo::Combo(Rect size) : Control(size)
{
	// Size of the textbox
	// Make the width shorter by the same amount as the height for the drop down icon
	this->heightTextBox = (Uint32)size.height();
	this->widthTextBox = (Uint32)size.width() - this->heightTextBox;
	
	// Size of the listbox
	this->widthListBox = (Uint32)size.width();
	this->heightListBox = 50;
	
	this->listActive = false; // Hide the listbox by default
	
	// Create the textbox
	Rect textboxSize = Rect(size.topLeft.x, size.topLeft.y, size.topLeft.x + this->widthTextBox, size.topLeft.y + this->heightTextBox);
	this->textBox = new TextBox(textboxSize);
	
	// Create the listbox
	Rect listboxSize = Rect(size.topLeft.x, size.topLeft.y + this->heightTextBox, size.topLeft.x + this->widthListBox, size.topLeft.y + this->heightListBox + this->heightTextBox);
	this->listBox = new ListBox(listboxSize);
}

Combo::~Combo()
{
	// clean up the controls
	if (this->textBox)
		delete this->textBox;
	
	if (this->listBox)
		delete this->listBox;
}

void Combo::draw(SDL_Surface* screenDest)
{
	if (this->textBox)
		this->textBox->draw(screenDest);
		
	if (this->listBox)
		this->listBox->draw(screenDest);
}

bool Combo::mouseDown(int x, int y, int button)
{
	return false;
}

bool Combo::mouseUp(int x, int y, int button)
{
	return false;
}

bool Combo::mouseMove(int x, int y)
{
	return false;
}

bool Combo::keyPress( SDLKey key, SDLMod mod, Uint16 character )
{
	// Fire a key event if the key matches our access key
	
	return false;
}
