/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
#include "CheckBox.h"

CheckBox::CheckBox(Point pos) : Control((int)pos.x, (int)pos.y, CHECKBOX_SIZE, CHECKBOX_SIZE)
{
	this->checked = false;
	this->changeEvent = NULL;
	
}

CheckBox::~CheckBox()
{
	
}
	
bool CheckBox::getChecked()
{
	return this->checked;
}

void CheckBox::setChecked(bool state)
{
	this->checked = state;
}

void CheckBox::draw(SDL_Surface* screenDest)
{
	SDL_Rect screenRect;
	screenRect.x = this->x;
	screenRect.y = this->y;
	screenRect.w = this->width;
	screenRect.h = this->height;
	
	// Draw the background text box
	Uint32 colour;
	if (this->active)
		colour = this->activeColour;
	else
		colour = this->inActiveColour;
	SDL_FillRect (screenDest, &screenRect, colour);
	
	// Draw a border around the textbox
	// Top and left in a dark colour
	// Bottom and right in a light colour
	
	// top
	Drawing::drawLine(screenDest, this->borderColTopLeft, this->x, this->y , this->x + this->width, this->y);
	// bottom
	Drawing::drawLine(screenDest, this->borderColBottomRight, this->x, this->y + this->height, this->x + this->width, this->y + this->height);
	// left
	Drawing::drawLine(screenDest, this->borderColTopLeft, this->x, this->y, this->x, this->y + this->height);
	// right
	Drawing::drawLine(screenDest, this->borderColBottomRight, this->x + this->width, this->y, this->x + this->width, this->y + this->height);
	
	if (this->checked)
	{
		Uint32 crossCol = SDL_MapRGB(screenDest->format, 0xff, 0xff, 0xff);
		
		// Draw out the text with a 2 pixel border
		Drawing::drawLine(screenDest, crossCol, this->x + 1, this->y + 1, this->x + this->width - 1, this->y + this->height - 1);
		Drawing::drawLine(screenDest, crossCol, this->x + this->width - 1, this->y + 1, this->x + 1, this->y + this->height - 1);
	}
	
}

bool CheckBox::mouseDown(int x, int y, int button)
{
	// Check if in my area
	if (!this->isPointOverMe(x,y))
	{
		this->active = false;
		return false;
	}
	
	this->checked = !this->checked;
	this->fireClickEvent();
	this->fireChangeEvent();
	this->active = true;
	
	return true;
}

bool CheckBox::keyPress( SDLKey key, SDLMod mod, Uint16 character )
{
	if (!active)
		return false;
	
	if (key == SDLK_SPACE)
	{
		this->checked = !this->checked;
		this->fireChangeEvent();
		return true;
	}
		
	return false;
}
