/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
 /*
  * A simple button to be placed on a window. It has a call back to fire when clicked
  * or the access key is pressed.
  * 
  */
 
#ifndef BUTTON_H
#define BUTTON_H

#include "Control.h"
#include "CallBack.h"

// Defines an access key which maps to any key that has been pressed.
const SDLKey ANY_KEY = SDLK_WORLD_0;
const Uint32 MOUSE_DOWN_MOVE = 2;

class Button : public Control
{
	
private:

	SDL_Surface* backgroundImage;			// Background image
	SDL_Surface* activeBackgroundImage;		// Alternative background image for when button is active
	SDL_Surface* mouseOverBackgroundImage;	// Alternative background image for when the mouse is over the button
	SDLKey accessKey;						// A short cut key which triggers the button / event
	Font* font;								// Define the font to use for the text of the button
	
	char* name;								// Text to appear on the button
	
	bool isMouseDown;						// Move the button down a bit to show it is pressed
	bool isMouseOver;						// Change the background image if the mouse is over it
		
public:
	// The button must have an event to call when clicked, along with the name
	Button(const char* name, Rect rect);
	virtual ~Button();

	// Basic Properties
	void loadBackgroundImage(const char* image);		// load the default background image
	void loadActiveBackgroundImage(const char* image);	// load an image to be displayed when this is active
	void loadMouseOverBackgroundImage(const char* image);// load an image to be displayed whtn the mouse is over
	void setAccessKey(SDLKey key);						// Set the shortcut key required to trigger this button
	void setFont(Font* font);							// Define the font used for the text on the button
	void setFont(char* fontFileName);					// Define the font used for the text on the button	
	
	// IWidget Methods
	virtual void draw(SDL_Surface* screenDest);
	virtual bool mouseDown(int x, int y, int button);
	virtual bool mouseUp(int x, int y, int button);
	virtual bool mouseMove(int x, int y);
	virtual bool keyPress( SDLKey key, SDLMod mod, Uint16 character );
};

#endif // BUTTON_H
