/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
/*
 *  Functions to check the status of the board after the last piece was played
 * 
 */
 
#ifndef _GAMESRULES_H_
#define _GAMESRULES_H_

#include "Board.h"

// Define the status of the game
enum WinningStatus
{
	None,
	Draw,
	Player1,
	Player2
};

class GamesRules
{
public:
	GamesRules();
	virtual ~GamesRules();
	
	
	WinningStatus hasPlayerWon(Board& board, int column, int row);
	WinningStatus hasPlayerWon(Board& board, int player, int column, int row);
	
	// Winning helper functions
	bool isCellSame(Board& board, int player, int column, int row, bool ignoreEmptyCells);
	int numOfHoriCounters(Board& board, int player, int column, int row, bool ignoreEmptyCells);
	int numOfVertCounters(Board& board, int player, int column, int row, bool ignoreEmptyCells);
	int numOfDiagTRBLCounters(Board& board, int player, int column, int row, bool ignoreEmptyCells);
	int numOfDiagTLBRCounters(Board& board, int player, int column, int row, bool ignoreEmptyCells);	
	
	// Find the number of counter / spaces in a row. i.e. the maximum number possible
	int numOfPossibleHoriCounters(Board& board, int player, int column, int row);
	int numOfPossibleVertCounters(Board& board, int player, int column, int row);
	int numOfPossibleDiagTRBLCounters(Board& board, int player, int column, int row);
	int numOfPossibleDiagTLBRCounters(Board& board, int player, int column, int row);	
	
};

#endif //_GAMESRULES_H_
