/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
#include "Board.h"

Board::Board()
{

}

Board::~Board()
{
	
}

void Board::reset()
{
	for (int col = 0; col < BOARD_COLS; col++)
		for (int row = 0; row < BOARD_ROWS; row++)
			board[col][row] = 0;
}

bool Board::isFull ()
{
   // checks if board full
  int row, col;
	 for (col = 0; (col < BOARD_COLS); col++)
	  for (row = 0; (row < BOARD_ROWS); row++)
	 	if (board[col][row] == 0) 
	 		return false;
	 		
	return true;
}

bool Board::isColumnFull (int column)
{   
	// checks if column is full
	return (nextSquareFree(column) >= BOARD_ROWS);
}

int Board::nextSquareFree(int column)
{	
	// returns next free square
	int c;
	for (c=0;(board[column][c] != 0) && (c < BOARD_ROWS); ++c);
	return c;
}

void Board::logBoard()
{
	// Write out the current board to the log file
	char line[BOARD_COLS+1];
	int col = 0;
	int row = 0;
	
	for(row = BOARD_ROWS - 1; row >= 0; row--)
	{
		for(col = 0; col < BOARD_COLS; col++)
		{
			if (board[col][row] == 0)
				line[col] = '0';
			else if (board[col][row] == 1)
				line[col] = '1';
			else
				line[col] = '2';
		}
		line[col] = 0;
		Log::Instance()->log(LOG_THRESHOLD, SV_DEBUG, line);	
	}

}

